/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.ACL;
import io.cloudboost.CloudApp;
import io.cloudboost.CloudException;
import io.cloudboost.CloudFile;
import io.cloudboost.CloudGeoPoint;
import io.cloudboost.CloudObjectArrayCallback;
import io.cloudboost.CloudObjectCallback;
import io.cloudboost.CloudQuery;
import io.cloudboost.CloudStringCallback;
import io.cloudboost.PrivateMethod;
import io.cloudboost.beans.CBResponse;
import io.cloudboost.json.JSONArray;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;
import io.cloudboost.util.CBParser;
import io.cloudboost.util.CloudSocket;
import io.socket.client.Ack;
import io.socket.emitter.Emitter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class CloudObject {
    public ACL acl = new ACL();
    protected JSONObject document;
    private CloudObject thisObj;
    protected ArrayList<String> _modifiedColumns = new ArrayList();

    public JSONObject getDocument() {
        return this.document;
    }

    public void setDocument(JSONObject document) {
        this.document = document;
    }

    public CloudObject(String tableName) {
        this._modifiedColumns.add("createdAt");
        this._modifiedColumns.add("updatedAt");
        this._modifiedColumns.add("ACL");
        this._modifiedColumns.add("expires");
        this.document = new JSONObject();
        try {
            this.document.put("_id", (Object)null);
            this.document.put("_tableName", tableName);
            this.document.put("_type", "custom");
            this.document.put("createdAt", (Object)null);
            this.document.put("updatedAt", (Object)null);
            this.document.put("ACL", this.acl.getACL());
            this.document.put("expires", JSONObject.NULL);
            this.document.put("_modifiedColumns", this._modifiedColumns);
            this.document.put("_isModified", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setAcl(ACL acl) {
        try {
            this.set("ACL", acl);
        }
        catch (CloudException e) {
            e.printStackTrace();
        }
    }

    public CloudObject(String tableName, String id) {
        this.document = new JSONObject();
        try {
            this.document.put("_id", id);
            this.document.put("_tableName", tableName);
            this.document.put("_type", "custom");
            this.document.put("ACL", this.acl.acl.toString());
            this.document.put("_isSearchable", false);
            this.document.put("createdAt", (Object)null);
            this.document.put("updatedAt", (Object)null);
            this.document.put("expires", (Object)null);
            this.document.put("_modifiedColumns", this._modifiedColumns);
            this.document.put("_isModified", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getId() {
        try {
            return this.document.get("_id").toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Date getCreatedAt() {
        try {
            return (Date)this.document.get("createdAt");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date getUpdatedAt() {
        try {
            return (Date)this.document.get("updatedAt");
        }
        catch (JSONException e) {
            return null;
        }
    }

    public boolean getIsSearchable() {
        try {
            return (Boolean)this.document.get("_isSearchable");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setIsSearchable(boolean value) {
        try {
            this.document.put("_isSearchable", value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public Calendar getExpires() {
        try {
            String str = this.document.getString("expires");
            return (Calendar)this.document.get("expires");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setExpires(Calendar value) {
        try {
            this.document.put("expires", value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean hasKey(String key) {
        return this.document.has(key);
    }

    public void set(String columnName, Object data) throws CloudException {
        String[] keywords = new String[]{"_tableName", "_type", "operator"};
        int index = -1;
        if (columnName.equals("id") || columnName.equals("_id")) {
            throw new CloudException("You cannot set Id on a CloudObject");
        }
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!keywords[i].equals(columnName)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            throw new CloudException(columnName + "is a keyword. Please choose a different column name.");
        }
        if (data instanceof CloudObject) {
            data = ((CloudObject)data).document;
        }
        if (data instanceof CloudGeoPoint) {
            data = ((CloudGeoPoint)data).document;
        }
        if (data instanceof CloudFile) {
            data = ((CloudFile)data).getDocument();
        }
        if (data instanceof ACL) {
            data = ((ACL)data).getACL();
        }
        try {
            if (data == null) {
                this.document.put(columnName, JSONObject.NULL);
            } else {
                this.document.put(columnName, data);
            }
            this._modifiedColumns.add(columnName);
            this.document.put("_modifiedColumns", this._modifiedColumns);
            this.document.put("_isModified", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void set(String columnName, Object[] data) throws CloudException {
        String[] keywords = new String[]{"_tableName", "_type", "operator"};
        int index = -1;
        if (columnName.equals("id") || columnName.equals("_id")) {
            throw new CloudException("You cannot set Id on a CloudObject");
        }
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!keywords[i].equals(columnName)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            throw new CloudException(columnName + "is a keyword. Please choose a different column name.");
        }
        try {
            if (data instanceof CloudObject[]) {
                CloudObject[] arrayList = (CloudObject[])data;
                ArrayList<JSONObject> objectArray = new ArrayList<JSONObject>();
                for (int i = 0; i < arrayList.length; ++i) {
                    objectArray.add(arrayList[i].document);
                }
                this.document.put(columnName, objectArray);
                this._modifiedColumns.add(columnName);
                this.document.put("_modifiedColumns", this._modifiedColumns);
            } else if (data instanceof CloudGeoPoint[]) {
                CloudGeoPoint[] arrayList = (CloudGeoPoint[])data;
                ArrayList<JSONObject> objectArray = new ArrayList<JSONObject>();
                for (int i = 0; i < arrayList.length; ++i) {
                    objectArray.add(arrayList[i].document);
                }
                this.document.put(columnName, objectArray);
                this._modifiedColumns.add(columnName);
                this.document.put("_modifiedColumns", this._modifiedColumns);
            } else {
                this.document.put(columnName, data);
                this._modifiedColumns.add(columnName);
                this.document.put("_modifiedColumns", this._modifiedColumns);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void set(String columnName, CloudObject[] data) throws CloudException {
        String[] keywords = new String[]{"_tableName", "_type", "operator"};
        int index = -1;
        if (columnName.equals("id") || columnName.equals("_id")) {
            throw new CloudException("You cannot set Id on a CloudObject");
        }
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!keywords[i].equals(columnName)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            throw new CloudException(columnName + "is a keyword. Please choose a different column name.");
        }
        ArrayList<JSONObject> objectArray = new ArrayList<JSONObject>();
        for (int i = 0; i < data.length; ++i) {
            objectArray.add(data[i].document);
        }
        try {
            this.document.put(columnName, objectArray);
            this._modifiedColumns.add(columnName);
            this.document.put("_modifiedColumns", this._modifiedColumns);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public Object get(String columnName) {
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        try {
            return this.document.get(columnName);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer getInteger(String columnName) {
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        try {
            return (Integer)this.document.get(columnName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public Boolean getBoolean(String columnName) {
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        try {
            return (Boolean)this.document.get(columnName);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Double getDouble(String columnName) {
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        try {
            return (Double)this.document.get(columnName);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public String getString(String columnName) {
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        try {
            return (String)this.document.get(columnName);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CloudObject getCloudObject(String columnName) {
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        JSONObject obj = null;
        CloudObject object = null;
        try {
            obj = new JSONObject(this.document.get(columnName).toString());
            object = new CloudObject(obj.getString("_tableName"));
        }
        catch (JSONException e) {
            try {
                this.document.put(columnName, "");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        object.document = obj;
        return object;
    }

    public CloudObject[] getCloudObjectArray(String columnName) {
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        JSONArray obj = new JSONArray();
        CloudObject[] object = null;
        try {
            obj = this.document.getJSONArray(columnName);
            object = new CloudObject[obj.length()];
            for (int i = 0; i < obj.length(); ++i) {
                object[i] = new CloudObject(obj.getJSONObject(i).getString("_tableName"));
                object[i].document = obj.getJSONObject(i);
            }
        }
        catch (JSONException e) {
            try {
                this.document.put(columnName, new String[10]);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        return object;
    }

    public Object[] getArray(String columnName) {
        if (columnName == "id" || columnName == "isSearchable") {
            columnName = "_" + columnName;
        }
        JSONArray data = null;
        try {
            data = this.document.getJSONArray(columnName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Object[] object = new Object[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            try {
                object[i] = data.get(i);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public void unset(String columnName) {
        try {
            this.document.put(columnName, (Object)null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void relate(String columnName, String tableName, String objectId) throws CloudException {
        if (columnName == "id" || columnName == "_id") {
            throw new CloudException("You cannot set the id of a CloudObject");
        }
        if (columnName == "id" || columnName == "expires") {
            throw new CloudException("You cannot link an object to this column");
        }
        CloudObject object = new CloudObject(tableName, objectId);
        try {
            this.document.put(columnName, object.document);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        PrivateMethod._isModified(this, columnName);
    }

    public static void on(String tableName, String eventType, final CloudQuery cloudQuery, final CloudObjectCallback callbackObject) throws CloudException {
        try {
            if (!cloudQuery.getTableName().equals(tableName)) {
                throw new CloudException("CloudQuery TableName and CloudNotification TableName should be same.");
            }
            if (cloudQuery.hasQuery() && (cloudQuery.include.size() > 0 || cloudQuery.includeList.size() > 0)) {
                throw new CloudException("Include with CloudNotificaitons is not supported right now.");
            }
            if (!cloudQuery.getSelect().toString().equals("{}")) {
                throw new CloudException("You cannot pass the query with select in CloudNotifications.");
            }
        }
        catch (CloudException e) {
            callbackObject.done(null, e);
            return;
        }
        tableName = tableName.toLowerCase();
        eventType = eventType.toLowerCase();
        if (eventType.equals("created") || eventType.equals("updated") || eventType.equals("deleted")) {
            String str = (CloudApp.getAppId() + "table" + tableName + eventType).toLowerCase();
            JSONObject payload = new JSONObject();
            try {
                payload.put("room", str);
                payload.put("sessionId", PrivateMethod._getSessionId());
                CloudSocket.getSocket().connect();
                CloudSocket.getSocket().emit("join-object-channel", new Object[]{payload, new Ack(){

                    public void call(Object ... args) {
                    }
                }});
                CloudSocket.getSocket().on(str.toLowerCase(), new Emitter.Listener(){

                    public void call(Object ... args) {
                        block6: {
                            try {
                                JSONObject body = new JSONObject(args[0].toString());
                                CloudObject object = new CloudObject(body.getString("_tableName"));
                                object.document = body;
                                boolean valid = CloudObject.validateNotificationQuery(object, cloudQuery);
                                if (!valid) break block6;
                                try {
                                    callbackObject.done(object, null);
                                }
                                catch (CloudException e) {
                                    try {
                                        callbackObject.done(null, e);
                                    }
                                    catch (CloudException e1) {
                                        e1.printStackTrace();
                                    }
                                    e.printStackTrace();
                                }
                            }
                            catch (JSONException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                });
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        } else {
            callbackObject.done(null, new CloudException("created, updated, deleted are supported notification types"));
        }
    }

    public static void on(String tableName, String eventType, final CloudObjectCallback callbackObject) throws CloudException {
        tableName = tableName.toLowerCase();
        if ((eventType = eventType.toLowerCase()).equals("created") || eventType.equals("updated") || eventType.equals("deleted")) {
            String str = (CloudApp.getAppId() + "table" + tableName + eventType).toLowerCase();
            JSONObject payload = new JSONObject();
            try {
                payload.put("room", str);
                payload.put("sessionId", PrivateMethod._getSessionId());
                CloudSocket.getSocket().connect();
                CloudSocket.getSocket().emit("join-object-channel", new Object[]{payload, new Ack(){

                    public void call(Object ... args) {
                    }
                }});
                CloudSocket.getSocket().on(str.toLowerCase(), new Emitter.Listener(){

                    public void call(Object ... args) {
                        try {
                            JSONObject body = new JSONObject(args[0].toString());
                            CloudObject object = new CloudObject(body.getString("_tableName"));
                            object.document = body;
                            try {
                                callbackObject.done(object, null);
                            }
                            catch (CloudException e) {
                                try {
                                    callbackObject.done(null, e);
                                }
                                catch (CloudException e1) {
                                    e1.printStackTrace();
                                }
                                e.printStackTrace();
                            }
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                        }
                    }
                });
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        } else {
            callbackObject.done(null, new CloudException("created, updated, deleted are supported notification types"));
        }
    }

    public static void on(String tableName, String[] eventType, CloudObjectCallback callbackObject) throws CloudException {
        for (int i = 0; i < eventType.length; ++i) {
            CloudObject.on(tableName, eventType[i], callbackObject);
        }
    }

    public static void on(String tableName, String[] eventType, CloudQuery query, CloudObjectCallback callbackObject) throws CloudException {
        for (int i = 0; i < eventType.length; ++i) {
            CloudObject.on(tableName, eventType[i], query, callbackObject);
        }
    }

    public static void off(String tableName, String[] eventType, CloudStringCallback callbackObject) throws CloudException {
        for (int i = 0; i < eventType.length; ++i) {
            CloudObject.off(tableName, eventType[i], callbackObject);
        }
    }

    public static void off(String tableName, String eventType, final CloudStringCallback callbackObj) throws CloudException {
        String str;
        JSONObject payload;
        tableName = tableName.toLowerCase();
        if ((eventType = eventType.toLowerCase()) == "created" || eventType == "updated" || eventType == "deleted") {
            payload = new JSONObject();
            str = (CloudApp.getAppId() + "table" + tableName + eventType).toLowerCase();
            try {
                payload.put("room", str);
                payload.put("sessionId", PrivateMethod._getSessionId());
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        } else {
            throw new CloudException("created, updated, deleted are supported notification types");
        }
        CloudSocket.getSocket().emit("leave-object-channel", new Object[]{payload, new Ack(){

            public void call(Object ... args) {
            }
        }});
        CloudSocket.getSocket().off(str, new Emitter.Listener(){

            public void call(Object ... args) {
                try {
                    callbackObj.done("success", null);
                }
                catch (CloudException e) {
                    try {
                        callbackObj.done(null, e);
                    }
                    catch (CloudException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public void save(CloudObjectCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        JSONObject data = new JSONObject();
        String url = null;
        CBResponse response = null;
        try {
            this.document.put("ACL", this.getAcl().getACL());
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + this.document.get("_tableName");
            response = CBParser.callJson(url, "PUT", data);
            if (response.getStatusCode() == 200) {
                String responseBody = response.getResponseBody();
                JSONObject body = new JSONObject(responseBody);
                this.thisObj = new CloudObject(body.get("_tableName").toString());
                this.thisObj.document = body;
                callbackObject.done(this.thisObj, null);
            } else {
                CloudException e = new CloudException(response.getStatusMessage());
                callbackObject.done(null, e);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            CloudException e = new CloudException(e1.getMessage());
            callbackObject.done(null, e);
        }
    }

    public void deleteAll(CloudObject[] array, CloudObjectArrayCallback callback) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        JSONObject data = new JSONObject();
        ArrayList<JSONObject> jsons = new ArrayList<JSONObject>();
        CBResponse response = null;
        int statusCode = 0;
        for (CloudObject ob : array) {
            jsons.add(ob.getDocument());
        }
        String url = null;
        try {
            data.put("key", CloudApp.getAppKey());
            data.put("document", jsons.toArray(new JSONObject[0]));
            url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + array[0].getDocument().get("_tableName");
            response = CBParser.callJson(url, "DELETE", data);
            statusCode = response.getStatusCode();
            if (statusCode == 200) {
                ArrayList<CloudObject> objects = new ArrayList<CloudObject>();
                JSONArray body = new JSONArray(response.getResponseBody());
                for (int i = 0; i < body.length(); ++i) {
                    JSONObject object = body.getJSONObject(i);
                    CloudObject cbObject = new CloudObject(object.get("_tableName").toString());
                    cbObject.document = object;
                    objects.add(cbObject);
                }
                callback.done(objects.toArray(new CloudObject[0]), null);
            } else {
                CloudException e = new CloudException(response.getResponseBody());
                callback.done(null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callback.done(null, e1);
        }
    }

    public void saveAll(CloudObject[] array, CloudObjectArrayCallback callback) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        JSONObject data = new JSONObject();
        ArrayList<JSONObject> jsons = new ArrayList<JSONObject>();
        CBResponse response = null;
        int statusCode = 0;
        for (CloudObject ob : array) {
            jsons.add(ob.getDocument());
        }
        String url = null;
        try {
            data.put("key", CloudApp.getAppKey());
            data.put("document", jsons.toArray(new JSONObject[0]));
            url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + array[0].getDocument().get("_tableName");
            response = CBParser.callJson(url, "PUT", data);
            statusCode = response.getStatusCode();
            if (statusCode == 200) {
                ArrayList<CloudObject> objects = new ArrayList<CloudObject>();
                JSONArray body = new JSONArray(response.getResponseBody());
                for (int i = 0; i < body.length(); ++i) {
                    JSONObject object = body.getJSONObject(i);
                    CloudObject cbObject = new CloudObject(object.get("_tableName").toString());
                    cbObject.document = object;
                    objects.add(cbObject);
                }
                callback.done(objects.toArray(new CloudObject[0]), null);
            } else {
                CloudException e = new CloudException(response.getResponseBody());
                callback.done(null, e);
            }
        }
        catch (JSONException e) {
            CloudException e1 = new CloudException(e.toString());
            callback.done(null, e1);
        }
    }

    public void fetch(final CloudObjectCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        if (this.getId() == null) {
            throw new CloudException("Can't fetch an object which is not saved");
        }
        try {
            CloudQuery q = null;
            q = this.document.getString("_type").equals("file") ? new CloudQuery("File") : new CloudQuery(this.document.getString("_tableName"));
            q.findById(this.getId(), new CloudObjectCallback(){

                @Override
                public void done(CloudObject x, CloudException t) throws CloudException {
                    callbackObject.done(x, t);
                }
            });
        }
        catch (JSONException e) {
            callbackObject.done(null, new CloudException(e.getMessage()));
        }
    }

    public void delete(CloudObjectCallback callbackObject) throws CloudException {
        if (CloudApp.getAppId() == null) {
            throw new CloudException("App Id is null");
        }
        if (this.getId() == null) {
            throw new CloudException("You cannot delete an object which is not saved.");
        }
        JSONObject data = null;
        String url = null;
        try {
            this.document.put("ACL", this.acl.getACL());
            this.thisObj = this;
            data = new JSONObject();
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            url = CloudApp.getApiUrl() + "/data/" + CloudApp.getAppId() + "/" + this.document.getString("_tableName");
            CBResponse response = CBParser.callJson(url, "DELETE", data);
            int statusCode = response.getStatusCode();
            if (statusCode == 200) {
                JSONObject body;
                this.thisObj.document = body = new JSONObject(response.getResponseBody());
                callbackObject.done(this.thisObj, null);
            } else {
                CloudException e = new CloudException(response.getResponseBody());
                callbackObject.done(null, e);
            }
        }
        catch (JSONException e2) {
            callbackObject.done(null, new CloudException(e2.getMessage()));
        }
    }

    protected static boolean validateNotificationQuery(CloudObject object, CloudQuery query) {
        boolean valid = false;
        if (query == null) {
            return valid;
        }
        if (!query.hasQuery()) {
            return valid;
        }
        if (query.getLimit() == 0) {
            return valid;
        }
        if (query.getSkip() > 0) {
            query.setSkip(query.getSkip() - 1);
            return valid;
        }
        JSONObject realQuery = query.getQuery();
        realQuery.remove("$include");
        realQuery.remove("$all");
        realQuery.remove("$includeList");
        try {
            if (CloudQuery.validateQuery(object, realQuery)) {
                valid = true;
            }
        }
        catch (JSONException e) {
            return valid;
        }
        return valid;
    }

    public CloudFile getFile(String columnName) throws CloudException {
        CloudFile file = null;
        try {
            JSONObject fileOb = this.document.getJSONObject(columnName);
            file = new CloudFile(fileOb);
            return file;
        }
        catch (JSONException e) {
            throw new CloudException("It seems column '" + columnName + "' does not contain a CloudFile");
        }
    }

    public ACL getAcl() {
        try {
            JSONObject ob;
            this.acl.acl = ob = (JSONObject)this.document.get("ACL");
            return this.acl;
        }
        catch (JSONException e) {
            return null;
        }
    }
}

