/**
*** Copyright (c) 2016-present,
*** Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.
***
*** This file is part of Catapult.
***
*** Catapult is free software: you can redistribute it and/or modify
*** it under the terms of the GNU Lesser General Public License as published by
*** the Free Software Foundation, either version 3 of the License, or
*** (at your option) any later version.
***
*** Catapult is distributed in the hope that it will be useful,
*** but WITHOUT ANY WARRANTY; without even the implied warranty of
*** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*** GNU Lesser General Public License for more details.
***
*** You should have received a copy of the GNU Lesser General Public License
*** along with Catapult. If not, see <http://www.gnu.org/licenses/>.
**/

package io.nem.symbol.catapult.builders;

import java.io.DataInputStream;
import java.io.SequenceInputStream;
import java.io.ByteArrayInputStream;

/** Factory in charge of creating the right transaction builder from the streamed data. */
public class TransactionBuilderFactory {

    /**
    * It creates the rigth embbeded transaction builder from the stream data.
    *
    * @param stream the stream
    * @return the EmbeddedTransactionBuilder subclass
    */
    public static EmbeddedTransactionBuilder createEmbeddedTransactionBuilder(final DataInputStream stream) {

        EmbeddedTransactionBuilder headerBuilder = EmbeddedTransactionBuilder.loadFromBinary(stream);
                                                                                                                                                                                    
        if (headerBuilder.getType().getValue() == 16716) {
            AccountLinkTransactionBodyBuilder bodyBuilder = AccountLinkTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedAccountLinkTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                                
        if (headerBuilder.getType().getValue() == 16712) {
            HashLockTransactionBodyBuilder bodyBuilder = HashLockTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedHashLockTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                
        if (headerBuilder.getType().getValue() == 16722) {
            SecretLockTransactionBodyBuilder bodyBuilder = SecretLockTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedSecretLockTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16978) {
            SecretProofTransactionBodyBuilder bodyBuilder = SecretProofTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedSecretProofTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16708) {
            AccountMetadataTransactionBodyBuilder bodyBuilder = AccountMetadataTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedAccountMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16964) {
            MosaicMetadataTransactionBodyBuilder bodyBuilder = MosaicMetadataTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedMosaicMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 17220) {
            NamespaceMetadataTransactionBodyBuilder bodyBuilder = NamespaceMetadataTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedNamespaceMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                        
        if (headerBuilder.getType().getValue() == 16717) {
            MosaicDefinitionTransactionBodyBuilder bodyBuilder = MosaicDefinitionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedMosaicDefinitionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16973) {
            MosaicSupplyChangeTransactionBodyBuilder bodyBuilder = MosaicSupplyChangeTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedMosaicSupplyChangeTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16725) {
            MultisigAccountModificationTransactionBodyBuilder bodyBuilder = MultisigAccountModificationTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedMultisigAccountModificationTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16974) {
            AddressAliasTransactionBodyBuilder bodyBuilder = AddressAliasTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedAddressAliasTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 17230) {
            MosaicAliasTransactionBodyBuilder bodyBuilder = MosaicAliasTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedMosaicAliasTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16718) {
            NamespaceRegistrationTransactionBodyBuilder bodyBuilder = NamespaceRegistrationTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedNamespaceRegistrationTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                
        if (headerBuilder.getType().getValue() == 16720) {
            AccountAddressRestrictionTransactionBodyBuilder bodyBuilder = AccountAddressRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedAccountAddressRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16976) {
            AccountMosaicRestrictionTransactionBodyBuilder bodyBuilder = AccountMosaicRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedAccountMosaicRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 17232) {
            AccountOperationRestrictionTransactionBodyBuilder bodyBuilder = AccountOperationRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedAccountOperationRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16977) {
            MosaicAddressRestrictionTransactionBodyBuilder bodyBuilder = MosaicAddressRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedMosaicAddressRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                    
        if (headerBuilder.getType().getValue() == 16721) {
            MosaicGlobalRestrictionTransactionBodyBuilder bodyBuilder = MosaicGlobalRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedMosaicGlobalRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16724) {
            TransferTransactionBodyBuilder bodyBuilder = TransferTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return EmbeddedTransferTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            return headerBuilder;
    }

    /**
    * It creates the rigth transaction builder from the stream data.
    *
    * @param stream the stream
    * @return the TransactionBuilder subclass
    */
    public static TransactionBuilder createTransactionBuilder(final DataInputStream stream) {

        TransactionBuilder headerBuilder = TransactionBuilder.loadFromBinary(stream);
                                                                                                                                                                                    
        if (headerBuilder.getType().getValue() == 16716) {
            AccountLinkTransactionBodyBuilder bodyBuilder = AccountLinkTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return AccountLinkTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                    
        if (headerBuilder.getType().getValue() == 16705) {
            AggregateTransactionBodyBuilder bodyBuilder = AggregateTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return AggregateCompleteTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
    
        if (headerBuilder.getType().getValue() == 16961) {
            AggregateTransactionBodyBuilder bodyBuilder = AggregateTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return AggregateBondedTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
        
        if (headerBuilder.getType().getValue() == 16712) {
            HashLockTransactionBodyBuilder bodyBuilder = HashLockTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return HashLockTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                
        if (headerBuilder.getType().getValue() == 16722) {
            SecretLockTransactionBodyBuilder bodyBuilder = SecretLockTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return SecretLockTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16978) {
            SecretProofTransactionBodyBuilder bodyBuilder = SecretProofTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return SecretProofTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16708) {
            AccountMetadataTransactionBodyBuilder bodyBuilder = AccountMetadataTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return AccountMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16964) {
            MosaicMetadataTransactionBodyBuilder bodyBuilder = MosaicMetadataTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return MosaicMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 17220) {
            NamespaceMetadataTransactionBodyBuilder bodyBuilder = NamespaceMetadataTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return NamespaceMetadataTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                        
        if (headerBuilder.getType().getValue() == 16717) {
            MosaicDefinitionTransactionBodyBuilder bodyBuilder = MosaicDefinitionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return MosaicDefinitionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16973) {
            MosaicSupplyChangeTransactionBodyBuilder bodyBuilder = MosaicSupplyChangeTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return MosaicSupplyChangeTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16725) {
            MultisigAccountModificationTransactionBodyBuilder bodyBuilder = MultisigAccountModificationTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return MultisigAccountModificationTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16974) {
            AddressAliasTransactionBodyBuilder bodyBuilder = AddressAliasTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return AddressAliasTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 17230) {
            MosaicAliasTransactionBodyBuilder bodyBuilder = MosaicAliasTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return MosaicAliasTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16718) {
            NamespaceRegistrationTransactionBodyBuilder bodyBuilder = NamespaceRegistrationTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return NamespaceRegistrationTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                
        if (headerBuilder.getType().getValue() == 16720) {
            AccountAddressRestrictionTransactionBodyBuilder bodyBuilder = AccountAddressRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return AccountAddressRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16976) {
            AccountMosaicRestrictionTransactionBodyBuilder bodyBuilder = AccountMosaicRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return AccountMosaicRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 17232) {
            AccountOperationRestrictionTransactionBodyBuilder bodyBuilder = AccountOperationRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return AccountOperationRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16977) {
            MosaicAddressRestrictionTransactionBodyBuilder bodyBuilder = MosaicAddressRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return MosaicAddressRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
                    
        if (headerBuilder.getType().getValue() == 16721) {
            MosaicGlobalRestrictionTransactionBodyBuilder bodyBuilder = MosaicGlobalRestrictionTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return MosaicGlobalRestrictionTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            
        if (headerBuilder.getType().getValue() == 16724) {
            TransferTransactionBodyBuilder bodyBuilder = TransferTransactionBodyBuilder.loadFromBinary(stream);
            SequenceInputStream concatenate = new SequenceInputStream(
            new ByteArrayInputStream(headerBuilder.serialize()),
            new ByteArrayInputStream(bodyBuilder.serialize()));
            return TransferTransactionBuilder.loadFromBinary(new DataInputStream(concatenate));
        }
            return headerBuilder;
    }

}
