/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class BalanceChangeReceiptBuilder
extends ReceiptBuilder
implements Serializer {
    private final MosaicBuilder mosaic;
    private final KeyDto targetPublicKey;

    protected BalanceChangeReceiptBuilder(DataInputStream stream) {
        super(stream);
        this.mosaic = MosaicBuilder.loadFromBinary(stream);
        this.targetPublicKey = KeyDto.loadFromBinary(stream);
    }

    protected BalanceChangeReceiptBuilder(short version, ReceiptTypeDto type, MosaicBuilder mosaic, KeyDto targetPublicKey) {
        super(version, type);
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(targetPublicKey, "targetPublicKey is null", new Object[0]);
        this.mosaic = mosaic;
        this.targetPublicKey = targetPublicKey;
    }

    public static BalanceChangeReceiptBuilder create(short version, ReceiptTypeDto type, MosaicBuilder mosaic, KeyDto targetPublicKey) {
        return new BalanceChangeReceiptBuilder(version, type, mosaic, targetPublicKey);
    }

    public MosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public KeyDto getTargetPublicKey() {
        return this.targetPublicKey;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.mosaic.getSize();
        return size += this.targetPublicKey.getSize();
    }

    public static BalanceChangeReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new BalanceChangeReceiptBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] mosaicBytes = this.mosaic.serialize();
            dataOutputStream.write(mosaicBytes, 0, mosaicBytes.length);
            byte[] targetPublicKeyBytes = this.targetPublicKey.serialize();
            dataOutputStream.write(targetPublicKeyBytes, 0, targetPublicKeyBytes.length);
        });
    }
}

