/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import java.io.DataInputStream;

public class CosignatureBuilder
implements Serializer {
    private final KeyDto signerPublicKey;
    private final SignatureDto signature;

    protected CosignatureBuilder(DataInputStream stream) {
        this.signerPublicKey = KeyDto.loadFromBinary(stream);
        this.signature = SignatureDto.loadFromBinary(stream);
    }

    protected CosignatureBuilder(KeyDto signerPublicKey, SignatureDto signature) {
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        this.signerPublicKey = signerPublicKey;
        this.signature = signature;
    }

    public static CosignatureBuilder create(KeyDto signerPublicKey, SignatureDto signature) {
        return new CosignatureBuilder(signerPublicKey, signature);
    }

    public KeyDto getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public SignatureDto getSignature() {
        return this.signature;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.signerPublicKey.getSize();
        return size += this.signature.getSize();
    }

    public static CosignatureBuilder loadFromBinary(DataInputStream stream) {
        return new CosignatureBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] signerPublicKeyBytes = this.signerPublicKey.serialize();
            dataOutputStream.write(signerPublicKeyBytes, 0, signerPublicKeyBytes.length);
            byte[] signatureBytes = this.signature.serialize();
            dataOutputStream.write(signatureBytes, 0, signatureBytes.length);
        });
    }
}

