/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.LockHashAlgorithmDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.SecretProofTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class EmbeddedSecretProofTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final SecretProofTransactionBodyBuilder secretProofTransactionBody;

    protected EmbeddedSecretProofTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.secretProofTransactionBody = SecretProofTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected EmbeddedSecretProofTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, Hash256Dto secret, LockHashAlgorithmDto hashAlgorithm, UnresolvedAddressDto recipientAddress, ByteBuffer proof) {
        super(signerPublicKey, version, network, type);
        this.secretProofTransactionBody = SecretProofTransactionBodyBuilder.create(secret, hashAlgorithm, recipientAddress, proof);
    }

    public static EmbeddedSecretProofTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, Hash256Dto secret, LockHashAlgorithmDto hashAlgorithm, UnresolvedAddressDto recipientAddress, ByteBuffer proof) {
        return new EmbeddedSecretProofTransactionBuilder(signerPublicKey, version, network, type, secret, hashAlgorithm, recipientAddress, proof);
    }

    public Hash256Dto getSecret() {
        return this.secretProofTransactionBody.getSecret();
    }

    public LockHashAlgorithmDto getHashAlgorithm() {
        return this.secretProofTransactionBody.getHashAlgorithm();
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.secretProofTransactionBody.getRecipientAddress();
    }

    public ByteBuffer getProof() {
        return this.secretProofTransactionBody.getProof();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.secretProofTransactionBody.getSize();
    }

    @Override
    public SecretProofTransactionBodyBuilder getBody() {
        return this.secretProofTransactionBody;
    }

    public static EmbeddedSecretProofTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedSecretProofTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] secretProofTransactionBodyBytes = this.secretProofTransactionBody.serialize();
            dataOutputStream.write(secretProofTransactionBodyBytes, 0, secretProofTransactionBodyBytes.length);
        });
    }
}

