/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class ImportanceHeightDto
implements Serializer {
    private final long importanceHeight;

    public ImportanceHeightDto(long importanceHeight) {
        this.importanceHeight = importanceHeight;
    }

    public ImportanceHeightDto(DataInputStream stream) {
        try {
            this.importanceHeight = Long.reverseBytes(stream.readLong());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public long getImportanceHeight() {
        return this.importanceHeight;
    }

    @Override
    public int getSize() {
        return 8;
    }

    public static ImportanceHeightDto loadFromBinary(DataInputStream stream) {
        return new ImportanceHeightDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeLong(Long.reverseBytes(this.getImportanceHeight())));
    }
}

