/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class MosaicExpiryReceiptBuilder
extends ReceiptBuilder
implements Serializer {
    private final MosaicIdDto artifactId;

    protected MosaicExpiryReceiptBuilder(DataInputStream stream) {
        super(stream);
        this.artifactId = MosaicIdDto.loadFromBinary(stream);
    }

    protected MosaicExpiryReceiptBuilder(short version, ReceiptTypeDto type, MosaicIdDto artifactId) {
        super(version, type);
        GeneratorUtils.notNull(artifactId, "artifactId is null", new Object[0]);
        this.artifactId = artifactId;
    }

    public static MosaicExpiryReceiptBuilder create(short version, ReceiptTypeDto type, MosaicIdDto artifactId) {
        return new MosaicExpiryReceiptBuilder(version, type, artifactId);
    }

    public MosaicIdDto getArtifactId() {
        return this.artifactId;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.artifactId.getSize();
    }

    public static MosaicExpiryReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicExpiryReceiptBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] artifactIdBytes = this.artifactId.serialize();
            dataOutputStream.write(artifactIdBytes, 0, artifactIdBytes.length);
        });
    }
}

