/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicResolutionEntryBuilder;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;

public final class MosaicResolutionStatementBuilder
extends ReceiptBuilder
implements Serializer {
    private final UnresolvedMosaicIdDto unresolved;
    private final List<MosaicResolutionEntryBuilder> resolutionEntries;

    protected MosaicResolutionStatementBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.unresolved = UnresolvedMosaicIdDto.loadFromBinary(stream);
            this.resolutionEntries = new ArrayList<MosaicResolutionEntryBuilder>();
            while (stream.available() > 0) {
                this.resolutionEntries.add(MosaicResolutionEntryBuilder.loadFromBinary(stream));
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected MosaicResolutionStatementBuilder(short version, ReceiptTypeDto type, UnresolvedMosaicIdDto unresolved, List<MosaicResolutionEntryBuilder> resolutionEntries) {
        super(version, type);
        GeneratorUtils.notNull(unresolved, "unresolved is null", new Object[0]);
        GeneratorUtils.notNull(resolutionEntries, "resolutionEntries is null", new Object[0]);
        this.unresolved = unresolved;
        this.resolutionEntries = resolutionEntries;
    }

    public static MosaicResolutionStatementBuilder create(short version, ReceiptTypeDto type, UnresolvedMosaicIdDto unresolved, List<MosaicResolutionEntryBuilder> resolutionEntries) {
        return new MosaicResolutionStatementBuilder(version, type, unresolved, resolutionEntries);
    }

    public UnresolvedMosaicIdDto getUnresolved() {
        return this.unresolved;
    }

    public List<MosaicResolutionEntryBuilder> getResolutionEntries() {
        return this.resolutionEntries;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.unresolved.getSize();
        return size += this.resolutionEntries.stream().mapToInt(o -> o.getSize()).sum();
    }

    public static MosaicResolutionStatementBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicResolutionStatementBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] unresolvedBytes = this.unresolved.serialize();
            dataOutputStream.write(unresolvedBytes, 0, unresolvedBytes.length);
            for (int i = 0; i < this.resolutionEntries.size(); ++i) {
                byte[] resolutionEntriesBytes = this.resolutionEntries.get(i).serialize();
                dataOutputStream.write(resolutionEntriesBytes, 0, resolutionEntriesBytes.length);
            }
        });
    }
}

