/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import java.io.DataInputStream;

public class TransactionBuilder
implements Serializer {
    private int size;
    private final int verifiableEntityHeader_Reserved1;
    private final SignatureDto signature;
    private final KeyDto signerPublicKey;
    private final int entityBody_Reserved1;
    private final byte version;
    private final NetworkTypeDto network;
    private final EntityTypeDto type;
    private final AmountDto fee;
    private final TimestampDto deadline;

    protected TransactionBuilder(DataInputStream stream) {
        try {
            this.size = Integer.reverseBytes(stream.readInt());
            this.verifiableEntityHeader_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.signature = SignatureDto.loadFromBinary(stream);
            this.signerPublicKey = KeyDto.loadFromBinary(stream);
            this.entityBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.version = stream.readByte();
            this.network = NetworkTypeDto.loadFromBinary(stream);
            this.type = EntityTypeDto.loadFromBinary(stream);
            this.fee = AmountDto.loadFromBinary(stream);
            this.deadline = TimestampDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected TransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline) {
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        this.verifiableEntityHeader_Reserved1 = 0;
        this.signature = signature;
        this.signerPublicKey = signerPublicKey;
        this.entityBody_Reserved1 = 0;
        this.version = version;
        this.network = network;
        this.type = type;
        this.fee = fee;
        this.deadline = deadline;
    }

    public static TransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline) {
        return new TransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline);
    }

    public int getStreamSize() {
        return this.size;
    }

    private int getVerifiableEntityHeader_Reserved1() {
        return this.verifiableEntityHeader_Reserved1;
    }

    public SignatureDto getSignature() {
        return this.signature;
    }

    public KeyDto getSignerPublicKey() {
        return this.signerPublicKey;
    }

    private int getEntityBody_Reserved1() {
        return this.entityBody_Reserved1;
    }

    public byte getVersion() {
        return this.version;
    }

    public NetworkTypeDto getNetwork() {
        return this.network;
    }

    public EntityTypeDto getType() {
        return this.type;
    }

    public AmountDto getFee() {
        return this.fee;
    }

    public TimestampDto getDeadline() {
        return this.deadline;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += this.signature.getSize();
        size += this.signerPublicKey.getSize();
        size += 4;
        ++size;
        size += this.network.getSize();
        size += this.type.getSize();
        size += this.fee.getSize();
        return size += this.deadline.getSize();
    }

    public Serializer getBody() {
        return null;
    }

    public static TransactionBuilder loadFromBinary(DataInputStream stream) {
        return new TransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getSize()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getVerifiableEntityHeader_Reserved1()));
            byte[] signatureBytes = this.signature.serialize();
            dataOutputStream.write(signatureBytes, 0, signatureBytes.length);
            byte[] signerPublicKeyBytes = this.signerPublicKey.serialize();
            dataOutputStream.write(signerPublicKeyBytes, 0, signerPublicKeyBytes.length);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getEntityBody_Reserved1()));
            dataOutputStream.writeByte(this.getVersion());
            byte[] networkBytes = this.network.serialize();
            dataOutputStream.write(networkBytes, 0, networkBytes.length);
            byte[] typeBytes = this.type.serialize();
            dataOutputStream.write(typeBytes, 0, typeBytes.length);
            byte[] feeBytes = this.fee.serialize();
            dataOutputStream.write(feeBytes, 0, feeBytes.length);
            byte[] deadlineBytes = this.deadline.serialize();
            dataOutputStream.write(deadlineBytes, 0, deadlineBytes.length);
        });
    }
}

