/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.api;

import java.util.Objects;
import java.util.function.BiFunction;

public abstract class CommandError {
    private final Reason reason;

    public static CommandError of(Reason reason, Throwable throwable) {
        return new ThrowableCommandError(reason, throwable);
    }

    public static CommandError of(Reason reason, String msg) {
        return new StringCommandError(reason, msg);
    }

    public Reason getReason() {
        return this.reason;
    }

    public abstract String getMessage();

    public abstract <A> A fold(BiFunction<Reason, String, A> var1, BiFunction<Reason, Throwable, A> var2);

    private CommandError(Reason reason) {
        this.reason = reason;
    }

    public String toString() {
        return "CommandError(" + this.fold((error, message) -> "Error: " + (Object)error + " Message: " + message, (error, throwable) -> "Error: " + (Object)error + " Throwable: " + throwable) + ')';
    }

    public static enum Reason {
        InvalidCommand,
        InvalidReadSequence,
        CommandHandlerFailed,
        AggregateNotFound,
        Timeout,
        RemoteLookupFailed,
        CommandPublishError,
        InternalError,
        UnexpectedErrorCode;

    }

    static final class StringCommandError
    extends CommandError {
        private final String msg;

        StringCommandError(Reason reason, String msg) {
            super(reason);
            this.msg = Objects.requireNonNull(msg);
        }

        @Override
        public String getMessage() {
            return this.msg;
        }

        @Override
        public <A> A fold(BiFunction<Reason, String, A> str, BiFunction<Reason, Throwable, A> ex) {
            return str.apply(this.getReason(), this.msg);
        }

        public int hashCode() {
            return 31 * this.getReason().hashCode() + this.msg.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringCommandError)) {
                return false;
            }
            StringCommandError other = (StringCommandError)obj;
            return Objects.equals((Object)this.getReason(), (Object)other.getReason()) && Objects.equals(this.msg, other.msg);
        }
    }

    static final class ThrowableCommandError
    extends CommandError {
        private final Throwable throwable;

        ThrowableCommandError(Reason reason, Throwable throwable) {
            super(reason);
            this.throwable = Objects.requireNonNull(throwable);
        }

        @Override
        public String getMessage() {
            return this.throwable.getMessage();
        }

        @Override
        public <A> A fold(BiFunction<Reason, String, A> str, BiFunction<Reason, Throwable, A> ex) {
            return ex.apply(this.getReason(), this.throwable);
        }

        public int hashCode() {
            return 31 * this.getReason().hashCode() + this.throwable.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ThrowableCommandError)) {
                return false;
            }
            ThrowableCommandError other = (ThrowableCommandError)obj;
            return Objects.equals((Object)this.getReason(), (Object)other.getReason()) && Objects.equals(this.throwable, other.throwable);
        }
    }
}

