/*
 * Decompiled with CFR 0.152.
 */
package optimajet.workflow.postgresql;

import optimajet.workflow.core.util.StringUtil;
import optimajet.workflow.persistence.sql.SqlDialect;

public final class PostgreSqlDialect
implements SqlDialect {
    private static final String PARAMETER_PLACEHOLDER = "\"%s\"";
    private static final String TABLE_PLACEHOLDER = "\"%s\".\"%s\"";
    private static final SqlDialect INSTANCE = new PostgreSqlDialect();

    public static SqlDialect getInstance() {
        return INSTANCE;
    }

    public String getParameterPlaceholder() {
        return PARAMETER_PLACEHOLDER;
    }

    public String formatParam(String paramName) {
        return String.format(PARAMETER_PLACEHOLDER, PostgreSqlDialect.upperCaseFirstLetter(paramName));
    }

    public String formatColumn(String columnName) {
        return PostgreSqlDialect.upperCaseFirstLetter(columnName);
    }

    public String formatTableName(String schemaName, String tableName) {
        if (!StringUtil.isNullOrWhiteSpace((String)schemaName)) {
            return String.format(TABLE_PLACEHOLDER, schemaName, tableName);
        }
        return String.format(PARAMETER_PLACEHOLDER, tableName);
    }

    private static String upperCaseFirstLetter(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private PostgreSqlDialect() {
    }
}

