/*
* The contents of this file are subject to the terms 
* of the Common Development and Distribution License 
* (the License).  You may not use this file except in
* compliance with the License.
* 
* You can obtain a copy of the license at 
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing 
* permissions and limitations under the License.
* 
* When distributing Covered Code, include this CDDL 
* Header Notice in each file and include the License file 
* at glassfish/bootstrap/legal/CDDLv1.0.txt.  
* If applicable, add the following below the CDDL Header, 
* with the fields enclosed by brackets [] replaced by
* you own identifying information: 
* "Portions Copyrighted [year] [name of copyright owner]"
* 
* Copyright 2007 Sun Microsystems, Inc. All rights reserved.
*/


package javax.xml.registry.infomodel;

import java.util.*;
import java.sql.Timestamp;
import javax.xml.registry.*;

/**
 * AuditableEvent instances provide a long term record of events that effect a 
 * change of state in a RegistryObject. Such events are usually a result of a 
 * client initiated request. AuditableEvent instances are generated by the 
 * registry service to log such events.
 * <p>
 * Often such events effect a change in the life cycle of a RegistryObject. 
 * For example a client request could Create, Update, Deprecate or Delete a 
 * RegistryObject. No AuditableEvent is created for requests that do not alter
 * the state of a RegistryObject. Specifically, read-only requests do not generate 
 * an AuditableEvent.  
 * No AuditableEvent is generated for a RegistryObject when it is classified, 
 * assigned to a Package or associated with another Object.
 * <p>
 * A RegistryObject is associated with an ordered Collection of AuditableEvent 
 * instances that provide a complete audit trail for that Object.
 *
 *
 * @see RegistryObject
 * @author Farrukh S. Najmi
 */
public interface AuditableEvent extends RegistryObject {

    /** Gets the User associated with this object.
     *
     * <p><DL><DT><B>Capability Level: 1 </B></DL> 	 
     *
	 * @return the User that sent the request that generated this this AuditableEvent. Must not be null
     * @throws JAXRException	If the JAXR provider encounters an internal error
     *
     * @label requestor
     * @supplierCardinality 1
     * @directed
     * @associates <{User}>
     */
    User getUser() throws JAXRException;

    /** 
	 * Gets the Timestamp for when this event occurred. 
	 *
	 * <p><DL><DT><B>Capability Level: 1 </B></DL> 	 
	 *
	 * @return the timestamp that records the time the event occured
	 * @throws JAXRException	If the JAXR provider encounters an internal error
	 *
	 */
    Timestamp getTimestamp() throws JAXRException;

    /** 
	 * Gets the type of this event.
	 *
	 * <p><DL><DT><B>Capability Level: 1 </B></DL> 	 
	 *
	 * @see AuditableEvent#EVENT_TYPE_CREATED
	 * @return the type of this event
	 * @throws JAXRException	If the JAXR provider encounters an internal error
	 *
	 */
    int getEventType() throws JAXRException;

    /** 
	 * Gets the RegistryObject associated with this AuditableEvent. 
	 *
	 * <p><DL><DT><B>Capability Level: 1 </B></DL> 	 
	 *
	 * @return the RegistryObject that was the focus of this event
	 * @throws JAXRException	If the JAXR provider encounters an internal error
	 *
	 */
    RegistryObject getRegistryObject() throws JAXRException;

	/** An event where a RegistryObject is created. */
	public static final int EVENT_TYPE_CREATED=0;
	
	/** An event where a RegistryObject is deleted. */
	public static final int EVENT_TYPE_DELETED=1;
	
	/** An event where a RegistryObject is deprecated. */	
	public static final int EVENT_TYPE_DEPRECATED=2;

	/** An event where a RegistryObject is updated. */
	public static final int EVENT_TYPE_UPDATED=3;

	/** An event where a RegistryObject is versioned. */
	public static final int EVENT_TYPE_VERSIONED=4;
	
	/** An event where a RegistryObject is undeprecated. */	
	public static final int EVENT_TYPE_UNDEPRECATED=5;

}
