/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.api;

/**
 * This interface defines the callback contract for the NumAPI.
 *
 * @author tonywalmsley
 */
public interface NumAPICallbacks {
    /**
     * Called when the result is available from DNS
     *
     * @param json The JSON String containing the result.
     */
    void setResult(final String json);

    /**
     * Called if an error occurs while retrieving or processing the NUM recocrd.
     *
     * @param error The error String.
     */
    void setErrorResult(final String error);

    /**
     * Check whether the record needs to be decrypted.
     *
     * @return true if the record is encrypted
     */
    boolean isEncrypted();

    /**
     * Set a flag to indicate whether the NUM record was encrypted or not.
     *
     * @param encrypted true if the NUM record was encrypted
     */
    void setEncrypted(final boolean encrypted);

    /**
     * Check whether the NUM record was encrypted when received from DNS.
     *
     * @return true if the record was encrypted.
     */
    boolean wasEncrypted();

    /**
     * Check whether the record was DNSSEC signed.
     *
     * @return true if the record was DNSSEC signed.
     */
    boolean isSignedDNSSEC();

    /**
     * Set a flag to indicate whether the record was DNSSEC signed or not.
     *
     * @param signedDNSSEC true if the record was DNSSEC signed
     */
    void setSignedDNSSEC(final boolean signedDNSSEC);

    /**
     * The type of location the NUM record was received from.
     *
     * @return Location::INDEPENDENT, Location::MANAGED, Location::POPULATED
     */
    Location receivedFrom();

    /**
     * Tell the library user whether the record retrieved from DNS was encrypted or not.
     *
     * @param wasEncrypted true if the record retrieved from DNS was encrypted
     */
    void setWasEncrypted(final boolean wasEncrypted);

    /**
     * Tell the library user where the record was retrieved from.
     *
     * @param location Location::INDEPENDENT, Location::MANAGED, Location::POPULATED
     */
    void setLocation(final Location location);


    /**
     * The type of location the NUM record was received from
     */
    enum Location {INDEPENDENT, MANAGED, POPULATED}
}
