/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.api;

/**
 * A default no-op implementation of the NumAPICallbacks.
 *
 * @author tonywalmsley
 */
public class NumAPICallbacksDefaultHandler implements NumAPICallbacks {

    private boolean encrypted;
    private boolean wasEncrypted;
    private boolean isSignedDNSSEC;
    private Location location;

    /**
     * Default constructor
     */
    public NumAPICallbacksDefaultHandler() {
    }

    /**
     * Tell the library user whether the record retrieved from DNS was encrypted or not.
     *
     * @param wasEncrypted true if the record retrieved from DNS was encrypted
     */
    public void setWasEncrypted(final boolean wasEncrypted) {
        // TODO: set this
        this.wasEncrypted = wasEncrypted;
    }

    /**
     * Tell the library user where the record was retrieved from.
     *
     * @param location Location::INDEPENDENT, Location::MANAGED, Location::POPULATED
     */
    public void setLocation(final Location location) {
        this.location = location;
    }

    /**
     * Called when the result is available from DNS
     *
     * @param json The JSON String containing the result.
     */
    @Override
    public void setResult(final String json) {
    }

    /**
     * Called if an error occurs while retrieving or processing the NUM recocrd.
     *
     * @param error The error String.
     */
    @Override
    public void setErrorResult(final String error) {

    }

    /**
     * Check whether the record needs to be decrypted.
     *
     * @return true if the record is encrypted
     */
    public boolean isEncrypted() {
        return this.encrypted;
    }

    /**
     * Set a flag to indicate whether the NUM record was encrypted or not.
     *
     * @param encrypted true if the NUM record was encrypted
     */
    public void setEncrypted(final boolean encrypted) {
        // TODO: set this
        this.encrypted = encrypted;
    }

    /**
     * Check whether the NUM record was encrypted when received from DNS.
     *
     * @return true if the record was encrypted.
     */
    public boolean wasEncrypted() {
        return this.wasEncrypted;
    }

    /**
     * Check whether the record was DNSSEC signed.
     *
     * @return true if the record was DNSSEC signed.
     */
    public boolean isSignedDNSSEC() {
        return isSignedDNSSEC;
    }

    /**
     * Set a flag to indicate whether the record was DNSSEC signed or not.
     *
     * @param signedDNSSEC true if the record was DNSSEC signed
     */
    public void setSignedDNSSEC(final boolean signedDNSSEC) {
        // TODO: set this
        isSignedDNSSEC = signedDNSSEC;
    }

    /**
     * The type of location the NUM record was received from.
     *
     * @return Location::INDEPENDENT, Location::MANAGED, Location::POPULATED
     */
    public Location receivedFrom() {
        return this.location;
    }

}
