/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.api;

import uk.num.numlib.exc.NumUserVariablesException;

/**
 * The context state for a given module and domain name combination
 *
 * @author tonywalmsley
 */
public interface NumAPIContext {
    /**
     * Modules can have required user variables that must be supplied before the NUM record csn be retrieved.
     *
     * @return An array of objects.
     */
    RequiredUserVariable[] getRequiredUserVariables();

    /**
     * Update the required user variables with values obtained from the client.
     *
     * @param requiredUserVariables The RequiredUserVariable array with the value fields populated.
     * @throws NumUserVariablesException on error
     */
    void setRequiredUserVariables(final RequiredUserVariable[] requiredUserVariables) throws NumUserVariablesException;
}
