/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations;

import cloud.commandframework.annotations.ArgumentMode;
import cloud.commandframework.annotations.SyntaxFragment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

final class SyntaxParser
implements Function<String, LinkedHashMap<String, SyntaxFragment>> {
    private static final Predicate<String> PATTERN_ARGUMENT_LITERAL = Pattern.compile("([A-Za-z0-9]+)(|([A-Za-z0-9]+))*").asPredicate();
    private static final Predicate<String> PATTERN_ARGUMENT_REQUIRED = Pattern.compile("<([A-Za-z0-9]+)>").asPredicate();
    private static final Predicate<String> PATTERN_ARGUMENT_OPTIONAL = Pattern.compile("\\[([A-Za-z0-9]+)]").asPredicate();

    SyntaxParser() {
    }

    @Override
    public @NonNull LinkedHashMap<@NonNull String, @NonNull SyntaxFragment> apply(@NonNull String syntax) {
        StringTokenizer stringTokenizer = new StringTokenizer(syntax, " ");
        LinkedHashMap<String, SyntaxFragment> map = new LinkedHashMap<String, SyntaxFragment>();
        while (stringTokenizer.hasMoreTokens()) {
            ArgumentMode mode;
            String major;
            String token = stringTokenizer.nextToken();
            ArrayList<String> minor = new ArrayList<String>();
            if (PATTERN_ARGUMENT_REQUIRED.test(token)) {
                major = token.substring(1, token.length() - 1);
                mode = ArgumentMode.REQUIRED;
            } else if (PATTERN_ARGUMENT_OPTIONAL.test(token)) {
                major = token.substring(1, token.length() - 1);
                mode = ArgumentMode.OPTIONAL;
            } else if (PATTERN_ARGUMENT_LITERAL.test(token)) {
                String[] literals = token.split("\\|");
                major = literals[0];
                minor.addAll(Arrays.asList(literals).subList(1, literals.length));
                mode = ArgumentMode.LITERAL;
            } else {
                throw new IllegalArgumentException(String.format("Unrecognizable syntax token '%s'", syntax));
            }
            map.put(major, new SyntaxFragment(major, minor, mode));
        }
        return map;
    }
}

