/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations;

import cloud.commandframework.annotations.AnnotationAccessor;
import cloud.commandframework.annotations.Argument;
import cloud.commandframework.annotations.Flag;
import cloud.commandframework.annotations.injection.ParameterInjector;
import cloud.commandframework.annotations.injection.ParameterInjectorRegistry;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.flags.FlagContext;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.execution.CommandExecutionHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

class MethodCommandExecutionHandler<C>
implements CommandExecutionHandler<C> {
    private final Parameter[] parameters;
    private final MethodHandle methodHandle;
    private final Map<String, CommandArgument<C, ?>> commandArguments;
    private final ParameterInjectorRegistry<C> injectorRegistry;
    private final AnnotationAccessor annotationAccessor;

    MethodCommandExecutionHandler(@NonNull Object instance, @NonNull Map<@NonNull String, @NonNull CommandArgument<@NonNull C, @NonNull ?>> commandArguments, @NonNull Method method, @NonNull ParameterInjectorRegistry<C> injectorRegistry) throws Exception {
        this.commandArguments = commandArguments;
        method.setAccessible(true);
        this.methodHandle = MethodHandles.lookup().unreflect(method).bindTo(instance);
        this.parameters = method.getParameters();
        this.injectorRegistry = injectorRegistry;
        this.annotationAccessor = AnnotationAccessor.of((AnnotatedElement)method);
    }

    public void execute(@NonNull CommandContext<C> commandContext) {
        ArrayList<Object> arguments = new ArrayList<Object>(this.parameters.length);
        FlagContext flagContext = commandContext.flags();
        for (Parameter parameter : this.parameters) {
            ParameterInjector<C, ?> injector;
            if (parameter.isAnnotationPresent(Argument.class)) {
                Argument argument = parameter.getAnnotation(Argument.class);
                CommandArgument<C, ?> commandArgument = this.commandArguments.get(argument.value());
                if (commandArgument.isRequired()) {
                    arguments.add(commandContext.get(argument.value()));
                    continue;
                }
                Object optional = commandContext.getOptional(argument.value()).orElse(null);
                arguments.add(optional);
                continue;
            }
            if (parameter.isAnnotationPresent(Flag.class)) {
                Flag flag = parameter.getAnnotation(Flag.class);
                if (parameter.getType() == Boolean.TYPE) {
                    arguments.add(flagContext.isPresent(flag.value()));
                    continue;
                }
                arguments.add(flagContext.getValue(flag.value(), null));
                continue;
            }
            if (parameter.getType().isAssignableFrom(commandContext.getSender().getClass())) {
                arguments.add(commandContext.getSender());
                continue;
            }
            Collection<ParameterInjector<C, ?>> injectors = this.injectorRegistry.injectors(parameter.getType());
            Object value = null;
            Iterator<ParameterInjector<C, ?>> iterator = injectors.iterator();
            while (iterator.hasNext() && (value = (Object)(injector = iterator.next()).create(commandContext, this.annotationAccessor)) == null) {
            }
            if (value != null) {
                arguments.add(value);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown command parameter '%s' in method '%s'", parameter.getName(), this.methodHandle.toString()));
        }
        try {
            this.methodHandle.invokeWithArguments(arguments);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CommandExecutionException(throwable);
        }
    }
}

