/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations.injection;

import cloud.commandframework.annotations.injection.ParameterInjector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ParameterInjectorRegistry<C> {
    private volatile int injectorCount = 0;
    private final Map<Class<?>, List<ParameterInjector<C, ?>>> injectors = new HashMap();

    public synchronized <T> void registerInjector(@NonNull Class<T> clazz, @NonNull ParameterInjector<C, T> injector) {
        this.injectors.computeIfAbsent(clazz, missingClass -> new LinkedList()).add(injector);
        ++this.injectorCount;
    }

    public synchronized <T> @NonNull Collection<@NonNull ParameterInjector<C, ?>> injectors(@NonNull Class<T> clazz) {
        ArrayList<@NonNull E> injectors = new ArrayList(this.injectorCount);
        for (Map.Entry<Class<?>, List<ParameterInjector<C, ?>>> entry : this.injectors.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            injectors.addAll(entry.getValue());
        }
        return Collections.unmodifiableCollection(injectors);
    }
}

