/*
 * LiblibAI API
 * LiblibAI x 星流 图像大模型API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package cloud.liblibai.openapi.client.api;

import cloud.liblibai.openapi.client.ApiCallback;
import cloud.liblibai.openapi.client.ApiClient;
import cloud.liblibai.openapi.client.ApiException;
import cloud.liblibai.openapi.client.ApiResponse;
import cloud.liblibai.openapi.client.Configuration;
import cloud.liblibai.openapi.client.Pair;
import cloud.liblibai.openapi.client.ProgressRequestBody;
import cloud.liblibai.openapi.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import cloud.liblibai.openapi.client.model.ComfyRequest;
import cloud.liblibai.openapi.client.model.ComfyStatusRequest;
import cloud.liblibai.openapi.client.model.ComfyStatusResponse;
import cloud.liblibai.openapi.client.model.GetModelVersion400Response;
import cloud.liblibai.openapi.client.model.GetModelVersion404Response;
import cloud.liblibai.openapi.client.model.GetModelVersionRequest;
import cloud.liblibai.openapi.client.model.ImageToImageRequest;
import cloud.liblibai.openapi.client.model.StatusRequest;
import cloud.liblibai.openapi.client.model.StatusResponse;
import cloud.liblibai.openapi.client.model.SubmitComfyResponse;
import cloud.liblibai.openapi.client.model.SubmitResponse;
import cloud.liblibai.openapi.client.model.TextToImageRequest;
import cloud.liblibai.openapi.client.model.TextToImageUltraRequest;
import cloud.liblibai.openapi.client.model.VersionResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for getComfyStatus
     * @param comfyStatusRequest 查询请求参数 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getComfyStatusCall(ComfyStatusRequest comfyStatusRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = comfyStatusRequest;

        // create path and map variables
        String localVarPath = "/api/generate/comfy/status";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getComfyStatusValidateBeforeCall(ComfyStatusRequest comfyStatusRequest, final ApiCallback _callback) throws ApiException {
        return getComfyStatusCall(comfyStatusRequest, _callback);

    }

    /**
     * 查询 comfy 生图结果
     * 根据生图任务uuid查询生图任务的状态和结果
     * @param comfyStatusRequest 查询请求参数 (optional)
     * @return ComfyStatusResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public ComfyStatusResponse getComfyStatus(ComfyStatusRequest comfyStatusRequest) throws ApiException {
        ApiResponse<ComfyStatusResponse> localVarResp = getComfyStatusWithHttpInfo(comfyStatusRequest);
        return localVarResp.getData();
    }

    /**
     * 查询 comfy 生图结果
     * 根据生图任务uuid查询生图任务的状态和结果
     * @param comfyStatusRequest 查询请求参数 (optional)
     * @return ApiResponse&lt;ComfyStatusResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ComfyStatusResponse> getComfyStatusWithHttpInfo(ComfyStatusRequest comfyStatusRequest) throws ApiException {
        okhttp3.Call localVarCall = getComfyStatusValidateBeforeCall(comfyStatusRequest, null);
        Type localVarReturnType = new TypeToken<ComfyStatusResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 查询 comfy 生图结果 (asynchronously)
     * 根据生图任务uuid查询生图任务的状态和结果
     * @param comfyStatusRequest 查询请求参数 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getComfyStatusAsync(ComfyStatusRequest comfyStatusRequest, final ApiCallback<ComfyStatusResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getComfyStatusValidateBeforeCall(comfyStatusRequest, _callback);
        Type localVarReturnType = new TypeToken<ComfyStatusResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getModelVersion
     * @param getModelVersionRequest 查询请求参数 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 未找到模型 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getModelVersionCall(GetModelVersionRequest getModelVersionRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = getModelVersionRequest;

        // create path and map variables
        String localVarPath = "/api/model/version/get";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getModelVersionValidateBeforeCall(GetModelVersionRequest getModelVersionRequest, final ApiCallback _callback) throws ApiException {
        return getModelVersionCall(getModelVersionRequest, _callback);

    }

    /**
     * 查询模型版本参数
     * 查询指定的模型版本参数。目前Lib已开放全站的可商用模型供API使用，您可以在Lib站内检索可商用的Checkpoint和LoRA模型。 选择喜欢的模型版本，从浏览器网址中复制versionUuid，粘贴到文生图或图生图的参数模板中使用。 若您忘记了在生图参数中应用的模型是哪一款，您可以调用本接口进行查询。 
     * @param getModelVersionRequest 查询请求参数 (optional)
     * @return VersionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 未找到模型 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
     </table>
     */
    public VersionResponse getModelVersion(GetModelVersionRequest getModelVersionRequest) throws ApiException {
        ApiResponse<VersionResponse> localVarResp = getModelVersionWithHttpInfo(getModelVersionRequest);
        return localVarResp.getData();
    }

    /**
     * 查询模型版本参数
     * 查询指定的模型版本参数。目前Lib已开放全站的可商用模型供API使用，您可以在Lib站内检索可商用的Checkpoint和LoRA模型。 选择喜欢的模型版本，从浏览器网址中复制versionUuid，粘贴到文生图或图生图的参数模板中使用。 若您忘记了在生图参数中应用的模型是哪一款，您可以调用本接口进行查询。 
     * @param getModelVersionRequest 查询请求参数 (optional)
     * @return ApiResponse&lt;VersionResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 未找到模型 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<VersionResponse> getModelVersionWithHttpInfo(GetModelVersionRequest getModelVersionRequest) throws ApiException {
        okhttp3.Call localVarCall = getModelVersionValidateBeforeCall(getModelVersionRequest, null);
        Type localVarReturnType = new TypeToken<VersionResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 查询模型版本参数 (asynchronously)
     * 查询指定的模型版本参数。目前Lib已开放全站的可商用模型供API使用，您可以在Lib站内检索可商用的Checkpoint和LoRA模型。 选择喜欢的模型版本，从浏览器网址中复制versionUuid，粘贴到文生图或图生图的参数模板中使用。 若您忘记了在生图参数中应用的模型是哪一款，您可以调用本接口进行查询。 
     * @param getModelVersionRequest 查询请求参数 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 未找到模型 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getModelVersionAsync(GetModelVersionRequest getModelVersionRequest, final ApiCallback<VersionResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getModelVersionValidateBeforeCall(getModelVersionRequest, _callback);
        Type localVarReturnType = new TypeToken<VersionResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStatus
     * @param statusRequest 查询请求参数 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStatusCall(StatusRequest statusRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = statusRequest;

        // create path and map variables
        String localVarPath = "/api/generate/webui/status";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStatusValidateBeforeCall(StatusRequest statusRequest, final ApiCallback _callback) throws ApiException {
        return getStatusCall(statusRequest, _callback);

    }

    /**
     * 查询生图任务状态
     * 根据生图任务uuid查询生图任务的状态和相关信息
     * @param statusRequest 查询请求参数 (optional)
     * @return StatusResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public StatusResponse getStatus(StatusRequest statusRequest) throws ApiException {
        ApiResponse<StatusResponse> localVarResp = getStatusWithHttpInfo(statusRequest);
        return localVarResp.getData();
    }

    /**
     * 查询生图任务状态
     * 根据生图任务uuid查询生图任务的状态和相关信息
     * @param statusRequest 查询请求参数 (optional)
     * @return ApiResponse&lt;StatusResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StatusResponse> getStatusWithHttpInfo(StatusRequest statusRequest) throws ApiException {
        okhttp3.Call localVarCall = getStatusValidateBeforeCall(statusRequest, null);
        Type localVarReturnType = new TypeToken<StatusResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 查询生图任务状态 (asynchronously)
     * 根据生图任务uuid查询生图任务的状态和相关信息
     * @param statusRequest 查询请求参数 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStatusAsync(StatusRequest statusRequest, final ApiCallback<StatusResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStatusValidateBeforeCall(statusRequest, _callback);
        Type localVarReturnType = new TypeToken<StatusResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitComfyTask
     * @param comfyRequest ComfyUI 工作流生图任务请求参数 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitComfyTaskCall(ComfyRequest comfyRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = comfyRequest;

        // create path and map variables
        String localVarPath = "/api/generate/comfyui/app";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitComfyTaskValidateBeforeCall(ComfyRequest comfyRequest, final ApiCallback _callback) throws ApiException {
        return submitComfyTaskCall(comfyRequest, _callback);

    }

    /**
     * 提交 ComfyUI 工作流生图任务
     * 提交 ComfyUI 工作流生图任务。目前Lib已开放全站的可商用、可在线运行工作流供API使用，您可以在Lib站内工作流合集检索。 在工作流的详情页会出现【本工作流已提供API服务】，且可查看API相关参数。（详情页未出现API参数的工作流，暂不支持API调用） 
     * @param comfyRequest ComfyUI 工作流生图任务请求参数 (optional)
     * @return SubmitComfyResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public SubmitComfyResponse submitComfyTask(ComfyRequest comfyRequest) throws ApiException {
        ApiResponse<SubmitComfyResponse> localVarResp = submitComfyTaskWithHttpInfo(comfyRequest);
        return localVarResp.getData();
    }

    /**
     * 提交 ComfyUI 工作流生图任务
     * 提交 ComfyUI 工作流生图任务。目前Lib已开放全站的可商用、可在线运行工作流供API使用，您可以在Lib站内工作流合集检索。 在工作流的详情页会出现【本工作流已提供API服务】，且可查看API相关参数。（详情页未出现API参数的工作流，暂不支持API调用） 
     * @param comfyRequest ComfyUI 工作流生图任务请求参数 (optional)
     * @return ApiResponse&lt;SubmitComfyResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubmitComfyResponse> submitComfyTaskWithHttpInfo(ComfyRequest comfyRequest) throws ApiException {
        okhttp3.Call localVarCall = submitComfyTaskValidateBeforeCall(comfyRequest, null);
        Type localVarReturnType = new TypeToken<SubmitComfyResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 提交 ComfyUI 工作流生图任务 (asynchronously)
     * 提交 ComfyUI 工作流生图任务。目前Lib已开放全站的可商用、可在线运行工作流供API使用，您可以在Lib站内工作流合集检索。 在工作流的详情页会出现【本工作流已提供API服务】，且可查看API相关参数。（详情页未出现API参数的工作流，暂不支持API调用） 
     * @param comfyRequest ComfyUI 工作流生图任务请求参数 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitComfyTaskAsync(ComfyRequest comfyRequest, final ApiCallback<SubmitComfyResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitComfyTaskValidateBeforeCall(comfyRequest, _callback);
        Type localVarReturnType = new TypeToken<SubmitComfyResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitImageToImage
     * @param imageToImageRequest 图生图任务请求参数 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitImageToImageCall(ImageToImageRequest imageToImageRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = imageToImageRequest;

        // create path and map variables
        String localVarPath = "/api/generate/webui/img2img";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitImageToImageValidateBeforeCall(ImageToImageRequest imageToImageRequest, final ApiCallback _callback) throws ApiException {
        return submitImageToImageCall(imageToImageRequest, _callback);

    }

    /**
     * 提交图生图任务
     * 提交图生图任务，生成图片
     * @param imageToImageRequest 图生图任务请求参数 (optional)
     * @return SubmitResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public SubmitResponse submitImageToImage(ImageToImageRequest imageToImageRequest) throws ApiException {
        ApiResponse<SubmitResponse> localVarResp = submitImageToImageWithHttpInfo(imageToImageRequest);
        return localVarResp.getData();
    }

    /**
     * 提交图生图任务
     * 提交图生图任务，生成图片
     * @param imageToImageRequest 图生图任务请求参数 (optional)
     * @return ApiResponse&lt;SubmitResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubmitResponse> submitImageToImageWithHttpInfo(ImageToImageRequest imageToImageRequest) throws ApiException {
        okhttp3.Call localVarCall = submitImageToImageValidateBeforeCall(imageToImageRequest, null);
        Type localVarReturnType = new TypeToken<SubmitResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 提交图生图任务 (asynchronously)
     * 提交图生图任务，生成图片
     * @param imageToImageRequest 图生图任务请求参数 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitImageToImageAsync(ImageToImageRequest imageToImageRequest, final ApiCallback<SubmitResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitImageToImageValidateBeforeCall(imageToImageRequest, _callback);
        Type localVarReturnType = new TypeToken<SubmitResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitTextToImage
     * @param textToImageRequest 文生图任务请求参数 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitTextToImageCall(TextToImageRequest textToImageRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = textToImageRequest;

        // create path and map variables
        String localVarPath = "/api/generate/webui/text2img";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitTextToImageValidateBeforeCall(TextToImageRequest textToImageRequest, final ApiCallback _callback) throws ApiException {
        return submitTextToImageCall(textToImageRequest, _callback);

    }

    /**
     * 提交文生图任务
     * 提交文生图任务，生成图片
     * @param textToImageRequest 文生图任务请求参数 (optional)
     * @return SubmitResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public SubmitResponse submitTextToImage(TextToImageRequest textToImageRequest) throws ApiException {
        ApiResponse<SubmitResponse> localVarResp = submitTextToImageWithHttpInfo(textToImageRequest);
        return localVarResp.getData();
    }

    /**
     * 提交文生图任务
     * 提交文生图任务，生成图片
     * @param textToImageRequest 文生图任务请求参数 (optional)
     * @return ApiResponse&lt;SubmitResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubmitResponse> submitTextToImageWithHttpInfo(TextToImageRequest textToImageRequest) throws ApiException {
        okhttp3.Call localVarCall = submitTextToImageValidateBeforeCall(textToImageRequest, null);
        Type localVarReturnType = new TypeToken<SubmitResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 提交文生图任务 (asynchronously)
     * 提交文生图任务，生成图片
     * @param textToImageRequest 文生图任务请求参数 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitTextToImageAsync(TextToImageRequest textToImageRequest, final ApiCallback<SubmitResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitTextToImageValidateBeforeCall(textToImageRequest, _callback);
        Type localVarReturnType = new TypeToken<SubmitResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitTextToImageUltra
     * @param textToImageUltraRequest 生图请求参数 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitTextToImageUltraCall(TextToImageUltraRequest textToImageUltraRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = textToImageUltraRequest;

        // create path and map variables
        String localVarPath = "/api/generate/webui/text2img/ultra";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitTextToImageUltraValidateBeforeCall(TextToImageUltraRequest textToImageUltraRequest, final ApiCallback _callback) throws ApiException {
        return submitTextToImageUltraCall(textToImageUltraRequest, _callback);

    }

    /**
     * 星流Star-3 Alpha图生图
     * 根据提供的文本提示词和参数生成图片
     * @param textToImageUltraRequest 生图请求参数 (optional)
     * @return SubmitResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public SubmitResponse submitTextToImageUltra(TextToImageUltraRequest textToImageUltraRequest) throws ApiException {
        ApiResponse<SubmitResponse> localVarResp = submitTextToImageUltraWithHttpInfo(textToImageUltraRequest);
        return localVarResp.getData();
    }

    /**
     * 星流Star-3 Alpha图生图
     * 根据提供的文本提示词和参数生成图片
     * @param textToImageUltraRequest 生图请求参数 (optional)
     * @return ApiResponse&lt;SubmitResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SubmitResponse> submitTextToImageUltraWithHttpInfo(TextToImageUltraRequest textToImageUltraRequest) throws ApiException {
        okhttp3.Call localVarCall = submitTextToImageUltraValidateBeforeCall(textToImageUltraRequest, null);
        Type localVarReturnType = new TypeToken<SubmitResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 星流Star-3 Alpha图生图 (asynchronously)
     * 根据提供的文本提示词和参数生成图片
     * @param textToImageUltraRequest 生图请求参数 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table border="1">
       <caption>Response Details</caption>
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 成功 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 请求参数错误 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 服务器内部错误 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitTextToImageUltraAsync(TextToImageUltraRequest textToImageUltraRequest, final ApiCallback<SubmitResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitTextToImageUltraValidateBeforeCall(textToImageUltraRequest, _callback);
        Type localVarReturnType = new TypeToken<SubmitResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
