/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.localstack;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.s3.AmazonS3;
import com.atlassian.localstack.LocalstackTestRunner;
import com.atlassian.localstack.TestUtils;
import com.atlassian.localstack.sample.S3Sample;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
public class BasicFunctionalityTest {
    @Test
    public void testLocalKinesisAPI() {
        AmazonKinesis kinesis = TestUtils.getClientKinesis();
        ListStreamsResult streams = kinesis.listStreams();
        Assert.assertNotNull((Object)streams.getStreamNames());
    }

    @Test
    public void testLocalS3API() throws Exception {
        AmazonS3 s3 = TestUtils.getClientS3();
        List buckets = s3.listBuckets();
        Assert.assertNotNull((Object)buckets);
        S3Sample.runTest(TestUtils.TEST_CREDENTIALS);
    }

    @Test
    public void testLocalLambdaAPI() {
        AWSLambda lambda = TestUtils.getClientLambda();
        ListFunctionsResult functions = lambda.listFunctions();
        Assert.assertNotNull((Object)functions.getFunctions());
    }

    static {
        TestUtils.setEnv((String)"AWS_CBOR_DISABLE", (String)"1");
    }
}

