/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.DockerTestUtils;
import cloud.localstack.TestUtils;
import cloud.localstack.docker.LocalstackDockerTestRunner;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazon.sqs.javamessaging.SQSConnectionFactory;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackDockerTestRunner.class)
@LocalstackDockerProperties(randomizePorts=true, services={"sqs"})
public class DockerOnlySQSFunctionalityTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testKinesisNotRunning() {
        this.thrown.expect(SdkClientException.class);
        AmazonKinesis kinesis = DockerTestUtils.getClientKinesis();
        kinesis.listStreams();
    }

    @Test
    public void testDynamoNotRunning() {
        this.thrown.expect(SdkClientException.class);
        AmazonDynamoDB dynamoDB = DockerTestUtils.getClientDynamoDb();
        ListTablesResult tablesResult = dynamoDB.listTables();
    }

    @Test
    public void testS3NotRunning() {
        this.thrown.expect(SdkClientException.class);
        AmazonS3 client = DockerTestUtils.getClientS3();
        client.createBucket("test-bucket");
    }

    @Test
    public void testSQSRunning() throws Exception {
        AmazonSQS client = DockerTestUtils.getClientSQS();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("DelaySeconds", "0");
        attributeMap.put("MaximumMessageSize", "262144");
        attributeMap.put("MessageRetentionPeriod", "1209600");
        attributeMap.put("ReceiveMessageWaitTimeSeconds", "20");
        attributeMap.put("VisibilityTimeout", "30");
        CreateQueueRequest createQueueRequest = new CreateQueueRequest("test-queue").withAttributes(attributeMap);
        client.createQueue(createQueueRequest);
        ListQueuesResult listQueuesResult = client.listQueues();
        Assert.assertThat((Object)listQueuesResult.getQueueUrls().size(), (Matcher)Is.is((Object)1));
        SQSConnection connection = this.createSQSConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test-queue");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("Hello World!");
        producer.send((Message)message);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage received = (TextMessage)consumer.receive();
        Assert.assertThat((Object)received.getText(), (Matcher)Is.is((Object)"Hello World!"));
    }

    private SQSConnection createSQSConnection() throws Exception {
        SQSConnectionFactory connectionFactory = SQSConnectionFactory.builder().withEndpoint(LocalstackDockerTestRunner.getLocalstackDocker().getEndpointSQS()).withAWSCredentialsProvider((AWSCredentialsProvider)new AWSStaticCredentialsProvider(TestUtils.TEST_CREDENTIALS)).build();
        return connectionFactory.createConnection();
    }

    static {
        TestUtils.setEnv((String)"AWS_CBOR_DISABLE", (String)"1");
    }
}

