/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LocalTestUtil;
import cloud.localstack.Localstack;
import cloud.localstack.LocalstackExtension;
import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.TestUtils;
import cloud.localstack.sample.KinesisLambdaHandler;
import cloud.localstack.sample.S3Sample;
import cloud.localstack.sample.SQSLambdaHandler;
import cloud.localstack.sample.SQSLambdaHandlerSSL;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.Runtime;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
@ExtendWith(value={LocalstackExtension.class})
public class BasicFunctionalityTest {
    @Test
    @org.junit.jupiter.api.Test
    public void testDevEnvironmentSetup() {
        Assertions.assertThat((boolean)Localstack.isDevEnvironment()).isTrue();
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testLocalKinesisAPI() throws InterruptedException {
        AmazonKinesis kinesis = TestUtils.getClientKinesis();
        ListStreamsResult streams = kinesis.listStreams();
        Assertions.assertThat((List)streams.getStreamNames()).isNotNull();
        String streamName = UUID.randomUUID().toString();
        kinesis.createStream(streamName, Integer.valueOf(1));
        Thread.sleep(500L);
        PutRecordRequest req = new PutRecordRequest();
        req.setPartitionKey("foobar-key");
        req.setData(ByteBuffer.wrap("{}".getBytes()));
        req.setStreamName(streamName);
        kinesis.putRecord(req);
        ByteBuffer data = ByteBuffer.wrap("{\"test\":\"test\"}".getBytes());
        kinesis.putRecord(streamName, data, "partition-key");
        kinesis.deleteStream(streamName);
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testKinesisLambdaIntegration() throws Exception {
        AmazonKinesis kinesis = TestUtils.getClientKinesis();
        AWSLambda lambda = TestUtils.getClientLambda();
        String functionName = UUID.randomUUID().toString();
        String streamName = UUID.randomUUID().toString();
        CreateFunctionRequest request = new CreateFunctionRequest();
        request.setFunctionName(functionName);
        request.setRuntime(Runtime.Java8);
        request.setCode(LocalTestUtil.createFunctionCode(KinesisLambdaHandler.class));
        request.setHandler(KinesisLambdaHandler.class.getName());
        lambda.createFunction(request);
        kinesis.createStream(streamName, Integer.valueOf(1));
        Thread.sleep(500L);
        String streamArn = kinesis.describeStream(streamName).getStreamDescription().getStreamARN();
        CreateEventSourceMappingRequest mapping = new CreateEventSourceMappingRequest();
        mapping.setFunctionName(functionName);
        mapping.setEventSourceArn(streamArn);
        mapping.setStartingPosition("LATEST");
        lambda.createEventSourceMapping(mapping);
        kinesis.putRecord(streamName, ByteBuffer.wrap("{\"foo\": \"bar\"}".getBytes()), "partitionKey1");
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testSQSLambdaIntegration() throws Exception {
        AmazonSQS clientSQS = TestUtils.getClientSQS();
        AWSLambda lambda = TestUtils.getClientLambda();
        AmazonS3 s3 = TestUtils.getClientS3();
        String functionName = UUID.randomUUID().toString();
        String sqsQueueName = UUID.randomUUID().toString();
        CreateFunctionRequest request = new CreateFunctionRequest();
        request.setFunctionName(functionName);
        request.setRuntime(Runtime.Java8);
        if (Localstack.useSSL()) {
            request.setCode(LocalTestUtil.createFunctionCode(SQSLambdaHandlerSSL.class));
            request.setHandler(SQSLambdaHandlerSSL.class.getName());
        } else {
            request.setCode(LocalTestUtil.createFunctionCode(SQSLambdaHandler.class));
            request.setHandler(SQSLambdaHandler.class.getName());
        }
        lambda.createFunction(request);
        CreateQueueResult queue = clientSQS.createQueue(sqsQueueName);
        Thread.sleep(500L);
        GetQueueAttributesResult queueAttributes = clientSQS.getQueueAttributes(new GetQueueAttributesRequest().withQueueUrl(queue.getQueueUrl()).withAttributeNames(new QueueAttributeName[]{QueueAttributeName.QueueArn}));
        String queueArn = (String)queueAttributes.getAttributes().get(QueueAttributeName.QueueArn.name());
        CreateEventSourceMappingRequest mapping = new CreateEventSourceMappingRequest();
        mapping.setFunctionName(functionName);
        mapping.setEventSourceArn(queueArn);
        lambda.createEventSourceMapping(mapping);
        String testBucket = UUID.randomUUID().toString();
        s3.createBucket(testBucket);
        clientSQS.sendMessage(queue.getQueueUrl(), testBucket);
        Thread.sleep(500L);
        ObjectListing objectListing = s3.listObjects(testBucket);
        Assertions.assertThat((List)objectListing.getObjectSummaries()).hasSize(1);
        String key = ((S3ObjectSummary)objectListing.getObjectSummaries().get(0)).getKey();
        Assertions.assertThat((String)key).startsWith((CharSequence)SQSLambdaHandler.fileName[0]);
        Assertions.assertThat((String)key).endsWith((CharSequence)SQSLambdaHandler.fileName[1]);
        String message = s3.getObjectAsString(testBucket, key);
        Assertions.assertThat((String)message).isEqualTo((Object)"Did you get the message?");
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testLocalS3API() throws Exception {
        AmazonS3 s3 = TestUtils.getClientS3();
        List buckets = s3.listBuckets();
        Assertions.assertThat((List)buckets).isNotNull();
        S3Sample.runTest(TestUtils.TEST_CREDENTIALS);
        String testBucket = UUID.randomUUID().toString();
        s3.createBucket(testBucket);
        File file = Files.createTempFile("localstack", "s3", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.putNextEntry(new ZipEntry("Some content"));
        zipOutputStream.write("Some text content".getBytes());
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        s3.putObject(testBucket, file.getName(), file);
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testLocalLambdaAPI() {
        AWSLambda lambda = TestUtils.getClientLambda();
        ListFunctionsResult functions = lambda.listFunctions();
        Assertions.assertThat((List)functions.getFunctions()).isNotNull();
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testLocalSQSAPI() {
        AmazonSQS sqs = TestUtils.getClientSQS();
        ListQueuesResult queues = sqs.listQueues();
        Assertions.assertThat((List)queues.getQueueUrls()).isNotNull();
        for (String queueName : Arrays.asList("java_test_queue", "java_test_queue.fifo")) {
            CreateQueueRequest createQueueRequest = new CreateQueueRequest();
            createQueueRequest.setQueueName(queueName);
            CreateQueueResult newQueue = sqs.createQueue(createQueueRequest);
            String queueUrl = newQueue.getQueueUrl();
            SendMessageRequest send = new SendMessageRequest(queueUrl, "body");
            SendMessageResult sendResult = sqs.sendMessage(send);
            Assertions.assertThat((String)sendResult.getMD5OfMessageBody()).isNotNull();
            ReceiveMessageRequest request = new ReceiveMessageRequest(queueUrl);
            request.setWaitTimeSeconds(Integer.valueOf(1));
            request.setMaxNumberOfMessages(Integer.valueOf(1));
            request.setMessageAttributeNames(Arrays.asList("All"));
            request.setAttributeNames(Arrays.asList("All"));
            ReceiveMessageResult result = sqs.receiveMessage(request);
            ((ListAssert)Assertions.assertThat((List)result.getMessages()).isNotNull()).hasSize(1);
            DeleteQueueRequest deleteQueue = new DeleteQueueRequest();
            deleteQueue.setQueueUrl(queueUrl);
            sqs.deleteQueue(deleteQueue);
        }
    }

    static {
        TestUtils.setEnv((String)"AWS_CBOR_DISABLE", (String)"1");
        if (Localstack.useSSL()) {
            TestUtils.disableSslCertChecking();
        }
    }
}

