/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.TestUtils;
import com.amazonaws.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ow2.proactive.process_tree_killer.ProcessTree;

public class Localstack {
    protected static final Localstack INSTANCE = new Localstack();
    private static final Logger LOG = Logger.getLogger(Localstack.class.getName());
    private static final AtomicReference<Process> INFRA_STARTED = new AtomicReference();
    private static final String INFRA_READY_MARKER = "Ready.";
    private static final String TMP_INSTALL_DIR = System.getProperty("java.io.tmpdir") + File.separator + "localstack_install_dir";
    private static final String CURRENT_DEV_DIR;
    private static boolean DEV_ENVIRONMENT;
    private static final String ADDITIONAL_PATH = "/usr/local/bin/";
    private static final String LOCALSTACK_REPO_URL = "https://github.com/localstack/localstack";
    public static final String ENV_CONFIG_USE_SSL = "USE_SSL";
    private static final String ENV_LOCALSTACK_PROCESS_GROUP = "ENV_LOCALSTACK_PROCESS_GROUP";

    private Localstack() {
    }

    public static boolean isDevEnvironment() {
        return DEV_ENVIRONMENT;
    }

    private static void setIsDevEnvironment(Path gitConfig) {
        Pattern remoteOrigin = Pattern.compile("^\\[remote \"origin\"]");
        Pattern localstackGit = Pattern.compile(".+\\/localstack\\.git$");
        boolean remoteOriginFound = false;
        try (Stream<String> lines = Files.lines(gitConfig);){
            for (String line : lines.collect(Collectors.toList())) {
                if (remoteOriginFound) {
                    DEV_ENVIRONMENT = localstackGit.matcher(line).matches();
                    break;
                }
                if (!remoteOrigin.matcher(line).matches()) continue;
                remoteOriginFound = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getEndpointS3() {
        return Localstack.getEndpointS3(false);
    }

    public static String getEndpointS3(boolean override_SSL) {
        String s3Endpoint = Localstack.ensureInstallationAndGetEndpoint("s3", override_SSL);
        s3Endpoint = s3Endpoint.replace("localhost", "test.localhost.atlassian.io");
        return s3Endpoint;
    }

    public static String getEndpointKinesis() {
        return Localstack.ensureInstallationAndGetEndpoint("kinesis");
    }

    public static String getEndpointLambda() {
        return Localstack.ensureInstallationAndGetEndpoint("lambda");
    }

    public static String getEndpointDynamoDB() {
        return Localstack.ensureInstallationAndGetEndpoint("dynamodb");
    }

    public static String getEndpointDynamoDBStreams() {
        return Localstack.ensureInstallationAndGetEndpoint("dynamodbstreams");
    }

    public static String getEndpointAPIGateway() {
        return Localstack.ensureInstallationAndGetEndpoint("apigateway");
    }

    public static String getEndpointElasticsearch() {
        return Localstack.ensureInstallationAndGetEndpoint("elasticsearch");
    }

    public static String getEndpointElasticsearchService() {
        return Localstack.ensureInstallationAndGetEndpoint("es");
    }

    public static String getEndpointFirehose() {
        return Localstack.ensureInstallationAndGetEndpoint("firehose");
    }

    public static String getEndpointSNS() {
        return Localstack.ensureInstallationAndGetEndpoint("sns");
    }

    public static String getEndpointSQS() {
        return Localstack.ensureInstallationAndGetEndpoint("sqs");
    }

    public static String getEndpointRedshift() {
        return Localstack.ensureInstallationAndGetEndpoint("redshift");
    }

    public static String getEndpointSES() {
        return Localstack.ensureInstallationAndGetEndpoint("ses");
    }

    public static String getEndpointRoute53() {
        return Localstack.ensureInstallationAndGetEndpoint("route53");
    }

    public static String getEndpointCloudFormation() {
        return Localstack.ensureInstallationAndGetEndpoint("cloudformation");
    }

    public static String getEndpointCloudWatch() {
        return Localstack.ensureInstallationAndGetEndpoint("cloudwatch");
    }

    public static String getEndpointSSM() {
        return Localstack.ensureInstallationAndGetEndpoint("ssm");
    }

    public static String getEndpointSecretsmanager() {
        return Localstack.ensureInstallationAndGetEndpoint("secretsmanager");
    }

    public static String getEndpointStepFunctions() {
        return Localstack.ensureInstallationAndGetEndpoint("stepfunctions");
    }

    private static void ensureInstallation() {
        Localstack.ensureInstallation(false);
    }

    private static void ensureInstallation(boolean initialSetup) {
        File dir = new File(TMP_INSTALL_DIR);
        File constantsFile = new File(dir, "localstack/constants.py");
        String logMsg = "Installing LocalStack to temporary directory (this may take a while): " + TMP_INSTALL_DIR;
        boolean messagePrinted = false;
        if (!constantsFile.exists()) {
            LOG.info(logMsg);
            messagePrinted = true;
            Localstack.deleteDirectory(dir);
            Localstack.exec("git clone https://github.com/localstack/localstack " + TMP_INSTALL_DIR);
        }
        if (DEV_ENVIRONMENT && initialSetup) {
            Path localstackDir = Paths.get(CURRENT_DEV_DIR, new String[0]);
            Path tempLocalstackDir = Paths.get(TMP_INSTALL_DIR, new String[0]);
            try {
                TestUtils.copyFolder(localstackDir, tempLocalstackDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Localstack.ensureJavaFilesRefreshedForDev();
        }
        File installationDoneMarker = new File(dir, "localstack/infra/installation.finished.marker");
        if (DEV_ENVIRONMENT && initialSetup || !installationDoneMarker.exists()) {
            if (!messagePrinted) {
                LOG.info(logMsg);
            }
            String useSSL = Localstack.useSSL() ? "USE_SSL=1" : "";
            Localstack.exec("cd \"" + TMP_INSTALL_DIR + "\";" + useSSL + " make install");
            try {
                installationDoneMarker.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void deleteDirectory(File dir) {
        try {
            if (dir.exists()) {
                Files.walk(dir.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void killProcess(Process p) {
        try {
            ProcessTree.get().killAll(Collections.singletonMap(ENV_LOCALSTACK_PROCESS_GROUP, ENV_LOCALSTACK_PROCESS_GROUP));
        }
        catch (Exception e) {
            LOG.warning("Unable to terminate processes: " + e);
        }
    }

    private static String ensureInstallationAndGetEndpoint(String service) {
        return Localstack.ensureInstallationAndGetEndpoint(service, false);
    }

    private static String ensureInstallationAndGetEndpoint(String service, boolean override_SSL) {
        Localstack.ensureInstallation();
        return Localstack.getEndpoint(service, override_SSL);
    }

    public static boolean useSSL() {
        return Localstack.isEnvConfigSet(ENV_CONFIG_USE_SSL);
    }

    public static boolean isEnvConfigSet(String configName) {
        String value = System.getenv(configName);
        return value != null && !Arrays.asList("false", "0", "").contains(value.trim());
    }

    private static String getEndpoint(String service, boolean override_SSL) {
        String useSSL = override_SSL || Localstack.useSSL() ? "USE_SSL=1" : "";
        String cmd = "cd '" + TMP_INSTALL_DIR + "'; . .venv/bin/activate; " + useSSL + " python -c 'import localstack_client.config; print(localstack_client.config.get_service_endpoint(\"" + service + "\"))'";
        Process p = Localstack.exec(cmd);
        try {
            return IOUtils.toString(p.getInputStream()).trim();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Process exec(String ... cmd) {
        return Localstack.exec(true, cmd);
    }

    private static Process exec(boolean wait, String ... cmd) {
        try {
            if (cmd.length == 1 && !new File(cmd[0]).exists()) {
                cmd = new String[]{"bash", "-c", cmd[0]};
            }
            HashMap<String, String> env = new HashMap<String, String>(System.getenv());
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.environment().put("PATH", "/usr/local/bin/:" + (String)env.get("PATH"));
            builder.environment().put(ENV_LOCALSTACK_PROCESS_GROUP, ENV_LOCALSTACK_PROCESS_GROUP);
            final Process p = builder.start();
            if (wait) {
                int code = p.waitFor();
                if (code != 0) {
                    String stderr = IOUtils.toString(p.getErrorStream());
                    String stdout = IOUtils.toString(p.getInputStream());
                    throw new IllegalStateException("Failed to run command '" + String.join((CharSequence)" ", cmd) + "', return code " + code + ".\nSTDOUT: " + stdout + "\nSTDERR: " + stderr);
                }
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        Localstack.killProcess(p);
                    }
                });
            }
            return p;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupInfrastructure() {
        AtomicReference<Process> atomicReference = INFRA_STARTED;
        synchronized (atomicReference) {
            Localstack.ensureInstallation(true);
            TestUtils.disableSslCertChecking();
            if (INFRA_STARTED.get() != null) {
                return;
            }
            String[] cmd = new String[]{"make", "-C", TMP_INSTALL_DIR, "infra"};
            try {
                String line;
                Process proc = Localstack.exec(false, cmd);
                BufferedReader r1 = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                LOG.info(TMP_INSTALL_DIR);
                LOG.info("Waiting for infrastructure to be spun up");
                boolean ready = false;
                String output = "";
                while ((line = r1.readLine()) != null) {
                    output = output + line + "\n";
                    if (!INFRA_READY_MARKER.equals(line)) continue;
                    ready = true;
                    break;
                }
                if (!ready) {
                    throw new RuntimeException("Unable to start local infrastructure. Debug output: " + output);
                }
                INFRA_STARTED.set(proc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void ensureJavaFilesRefreshedForDev() {
        String[] cmdPrepareJava = new String[]{"make", "-C", CURRENT_DEV_DIR, "prepare-java-tests-infra-jars"};
        Localstack.exec(true, cmdPrepareJava);
        Path currentInfraPath = Paths.get(CURRENT_DEV_DIR, "localstack", "infra");
        Path tmpInfraPath = Paths.get(TMP_INSTALL_DIR, "localstack", "infra");
        Path localstackUtilsFatJar = Paths.get(currentInfraPath.toString(), "localstack-utils-fat.jar");
        Path localstackUtilsTestsJar = Paths.get(currentInfraPath.toString(), "localstack-utils-tests.jar");
        if (Files.exists(localstackUtilsFatJar, new LinkOption[0])) {
            Path tempInstallDirFatJar = Paths.get(tmpInfraPath.toString(), "localstack-utils-fat.jar");
            TestUtils.copy(localstackUtilsFatJar, tempInstallDirFatJar);
        }
        if (Files.exists(localstackUtilsTestsJar, new LinkOption[0])) {
            Path tempInstallDirTestsJar = Paths.get(tmpInfraPath.toString(), "localstack-utils-tests.jar");
            TestUtils.copy(localstackUtilsTestsJar, tempInstallDirTestsJar);
        }
    }

    public static void teardownInfrastructure() {
        Process proc = INFRA_STARTED.get();
        if (proc == null) {
            return;
        }
        Localstack.killProcess(proc);
        INFRA_STARTED.set(null);
    }

    public static String getDefaultRegion() {
        return "us-east-1";
    }

    static {
        Path currentDirectory = Paths.get(".", new String[0]).toAbsolutePath().getParent();
        Path localstackDir = Optional.ofNullable(currentDirectory).map(Path::getParent).map(Path::getParent).map(Path::getParent).orElse(null);
        if (currentDirectory != null && localstackDir != null && currentDirectory.getFileName().toString().equals("java") && localstackDir.getFileName().toString().equals("localstack")) {
            CURRENT_DEV_DIR = localstackDir.toString();
            Path gitConfig = Paths.get(CURRENT_DEV_DIR, ".git", "config");
            if (Files.exists(gitConfig, new LinkOption[0])) {
                Localstack.setIsDevEnvironment(gitConfig);
            } else {
                DEV_ENVIRONMENT = false;
            }
        } else {
            CURRENT_DEV_DIR = currentDirectory.toAbsolutePath().toString();
            DEV_ENVIRONMENT = false;
        }
    }
}

