/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.apache.http.client.protocol;

import com.amazonaws.thirdparty.apache.commons.logging.Log;
import com.amazonaws.thirdparty.apache.commons.logging.LogFactory;
import com.amazonaws.thirdparty.apache.http.HttpException;
import com.amazonaws.thirdparty.apache.http.HttpRequest;
import com.amazonaws.thirdparty.apache.http.HttpRequestInterceptor;
import com.amazonaws.thirdparty.apache.http.annotation.Contract;
import com.amazonaws.thirdparty.apache.http.annotation.ThreadingBehavior;
import com.amazonaws.thirdparty.apache.http.client.protocol.HttpClientContext;
import com.amazonaws.thirdparty.apache.http.conn.routing.RouteInfo;
import com.amazonaws.thirdparty.apache.http.protocol.HttpContext;
import com.amazonaws.thirdparty.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

