/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.apache.http.impl;

import com.amazonaws.thirdparty.apache.http.ConnectionReuseStrategy;
import com.amazonaws.thirdparty.apache.http.Header;
import com.amazonaws.thirdparty.apache.http.HeaderIterator;
import com.amazonaws.thirdparty.apache.http.HttpRequest;
import com.amazonaws.thirdparty.apache.http.HttpResponse;
import com.amazonaws.thirdparty.apache.http.HttpVersion;
import com.amazonaws.thirdparty.apache.http.ParseException;
import com.amazonaws.thirdparty.apache.http.ProtocolVersion;
import com.amazonaws.thirdparty.apache.http.TokenIterator;
import com.amazonaws.thirdparty.apache.http.annotation.Contract;
import com.amazonaws.thirdparty.apache.http.annotation.ThreadingBehavior;
import com.amazonaws.thirdparty.apache.http.message.BasicTokenIterator;
import com.amazonaws.thirdparty.apache.http.protocol.HttpContext;
import com.amazonaws.thirdparty.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpResponse response, HttpContext context) {
        HeaderIterator headerIterator;
        ProtocolVersion ver;
        block19: {
            Args.notNull(response, "HTTP response");
            Args.notNull(context, "HTTP context");
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            if (request != null) {
                try {
                    BasicTokenIterator ti = new BasicTokenIterator(request.headerIterator("Connection"));
                    while (ti.hasNext()) {
                        String token = ti.nextToken();
                        if (!"Close".equalsIgnoreCase(token)) continue;
                        return false;
                    }
                }
                catch (ParseException px) {
                    return false;
                }
            }
            ver = response.getStatusLine().getProtocolVersion();
            Header teh = response.getFirstHeader("Transfer-Encoding");
            if (teh != null) {
                if (!"chunked".equalsIgnoreCase(teh.getValue())) {
                    return false;
                }
            } else if (this.canResponseHaveBody(request, response)) {
                Header[] clhs = response.getHeaders("Content-Length");
                if (clhs.length == 1) {
                    Header clh = clhs[0];
                    try {
                        int contentLen = Integer.parseInt(clh.getValue());
                        if (contentLen < 0) {
                            return false;
                        }
                        break block19;
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                return false;
            }
        }
        if (!(headerIterator = response.headerIterator("Connection")).hasNext()) {
            headerIterator = response.headerIterator("Proxy-Connection");
        }
        if (headerIterator.hasNext()) {
            try {
                BasicTokenIterator ti = new BasicTokenIterator(headerIterator);
                boolean keepalive = false;
                while (ti.hasNext()) {
                    String token = ti.nextToken();
                    if ("Close".equalsIgnoreCase(token)) {
                        return false;
                    }
                    if (!"Keep-Alive".equalsIgnoreCase(token)) continue;
                    keepalive = true;
                }
                if (keepalive) {
                    return true;
                }
            }
            catch (ParseException px) {
                return false;
            }
        }
        return !ver.lessEquals(HttpVersion.HTTP_1_0);
    }

    protected TokenIterator createTokenIterator(HeaderIterator hit) {
        return new BasicTokenIterator(hit);
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if (request != null && request.getRequestLine().getMethod().equalsIgnoreCase("HEAD")) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }
}

