/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.docker.PortMapping;
import cloud.localstack.docker.command.ExecCommand;
import cloud.localstack.docker.command.LogCommand;
import cloud.localstack.docker.command.PortCommand;
import cloud.localstack.docker.command.PullCommand;
import cloud.localstack.docker.command.RunCommand;
import cloud.localstack.docker.command.StopCommand;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Container {
    private static final Logger LOG = Logger.getLogger(Container.class.getName());
    private static final String LOCALSTACK_NAME = "localstack/localstack";
    private static final String LOCALSTACK_PORTS = "4567-4583";
    private static final String LOCALSTACK_EXTERNAL_HOSTNAME = "HOSTNAME_EXTERNAL";
    private static final int MAX_PORT_CONNECTION_ATTEMPTS = 10;
    private static final int MAX_LOG_COLLECTION_ATTEMPTS = 120;
    private static final long POLL_INTERVAL = 1000L;
    private static final int NUM_LOG_LINES = 10;
    private final String containerId;
    private final List<PortMapping> ports;

    public static Container createLocalstackContainer(String externalHostName) {
        LOG.info("Pulling latest image...");
        new PullCommand(LOCALSTACK_NAME).execute();
        String containerId = new RunCommand(LOCALSTACK_NAME).withExposedPorts(LOCALSTACK_PORTS).withEnvironmentVariable(LOCALSTACK_EXTERNAL_HOSTNAME, externalHostName).execute();
        LOG.info("Started container: " + containerId);
        List<PortMapping> portMappings = new PortCommand(containerId).execute();
        return new Container(containerId, portMappings);
    }

    private Container(String containerId, List<PortMapping> ports) {
        this.containerId = containerId;
        this.ports = Collections.unmodifiableList(ports);
    }

    public int getExternalPortFor(int internalPort) {
        return this.ports.stream().filter(port -> port.getInternalPort() == internalPort).map(PortMapping::getExternalPort).findFirst().orElseThrow(() -> new IllegalArgumentException("Port: " + internalPort + " does not exist"));
    }

    public void waitForAllPorts(String ip) {
        this.ports.forEach(port -> this.waitForPort(ip, (PortMapping)port));
    }

    private void waitForPort(String ip, PortMapping port) {
        int attempts = 0;
        do {
            if (!this.isPortOpen(ip, port)) continue;
            return;
        } while (++attempts < 10);
        throw new IllegalStateException("Could not open port:" + port.getExternalPort() + " on ip:" + port.getIp());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPortOpen(String ip, PortMapping port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(ip, port.getExternalPort()), 1000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void waitForLogToken(Pattern pattern) {
        int attempts = 0;
        do {
            if (this.logContainsPattern(pattern)) {
                return;
            }
            this.waitForLogs();
        } while (++attempts < 120);
        throw new IllegalStateException("Could not find token: " + pattern.toString() + " in docker logs.");
    }

    private boolean logContainsPattern(Pattern pattern) {
        String logs = new LogCommand(this.containerId).withNumberOfLines(10).execute();
        return pattern.matcher(logs).find();
    }

    private void waitForLogs() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
        new StopCommand(this.containerId).execute();
        LOG.info("Stopped container: " + this.containerId);
    }

    public String executeCommand(List<String> command) {
        return new ExecCommand(this.containerId).execute(command);
    }
}

