/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.Localstack;
import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.TestUtils;
import cloud.localstack.utils.PromiseAsyncHandler;
import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazon.sqs.javamessaging.SQSConnectionFactory;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
public class SQSMessagingTest {
    private static final String JMS_QUEUE_NAME = "aws_develop_class_jms";
    private static final String SAMPLE_QUEUE_NAME = "aws_develop_class";
    private static final String SAMPLE_MULTI_BYTE_CHAR_QUEUE_NAME = "aws_develop_multi_byte";

    @BeforeClass
    public static void setup() {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("DelaySeconds", "0");
        attributeMap.put("MaximumMessageSize", "262144");
        attributeMap.put("MessageRetentionPeriod", "1209600");
        attributeMap.put("ReceiveMessageWaitTimeSeconds", "20");
        attributeMap.put("VisibilityTimeout", "30");
        AmazonSQS client = TestUtils.getClientSQS();
        CreateQueueRequest createQueueRequest = new CreateQueueRequest(JMS_QUEUE_NAME).withAttributes(attributeMap);
        CreateQueueResult result = client.createQueue(createQueueRequest);
        Assert.assertNotNull((Object)result);
        if (Localstack.useSSL()) {
            TestUtils.disableSslCertChecking();
        }
    }

    @Test
    public void testSendMessage() throws JMSException {
        SQSConnectionFactory connectionFactory = SQSConnectionFactory.builder().withEndpoint(Localstack.INSTANCE.getEndpointSQS()).withAWSCredentialsProvider((AWSCredentialsProvider)new AWSStaticCredentialsProvider(TestUtils.TEST_CREDENTIALS)).build();
        SQSConnection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(JMS_QUEUE_NAME);
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("This is a message!");
        producer.send((javax.jms.Message)message);
        Assert.assertNotNull((Object)message.getJMSMessageID());
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage received = (TextMessage)consumer.receive();
        Assert.assertNotNull((Object)received);
    }

    @Test
    public void testSendMessageAsync() throws Exception {
        AmazonSQSAsync clientSQSAsync = TestUtils.getClientSQSAsync();
        PromiseAsyncHandler createQueuePromise = new PromiseAsyncHandler();
        clientSQSAsync.createQueueAsync(SAMPLE_QUEUE_NAME, createQueuePromise);
        CompletionStage queueUrl = createQueuePromise.thenCompose(createQueueResult -> {
            PromiseAsyncHandler sendMessagePromise = new PromiseAsyncHandler();
            clientSQSAsync.sendMessageAsync(createQueueResult.getQueueUrl(), "message", sendMessagePromise);
            return sendMessagePromise.thenApply(e -> createQueueResult.getQueueUrl());
        });
        String queue = (String)((CompletableFuture)queueUrl).get(3L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)queue);
        PromiseAsyncHandler receiveMessagePromise = new PromiseAsyncHandler();
        clientSQSAsync.receiveMessageAsync(queue, receiveMessagePromise);
        CompletionStage receivedMessage = receiveMessagePromise.thenApply(e -> (Message)e.getMessages().get(0));
        Assert.assertEquals((Object)((Message)((CompletableFuture)receivedMessage).get(3L, TimeUnit.SECONDS)).getBody(), (Object)"message");
    }

    @Test
    public void testSendMultiByteCharactersMessage() throws JMSException {
        AmazonSQS clientSQS = TestUtils.getClientSQS();
        String queueUrl = clientSQS.createQueue(SAMPLE_MULTI_BYTE_CHAR_QUEUE_NAME).getQueueUrl();
        String messageBody = "foo";
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
        messageAttributes.put("XXX", new MessageAttributeValue().withDataType("String").withStringValue("\ud83d\ude07"));
        SendMessageRequest sendMessageRequest = new SendMessageRequest();
        sendMessageRequest.withMessageBody("foo");
        sendMessageRequest.withQueueUrl(queueUrl);
        sendMessageRequest.withMessageAttributes(messageAttributes);
        SendMessageResult sendMessageResult = clientSQS.sendMessage(sendMessageRequest);
        Assert.assertNotNull((Object)sendMessageResult);
        Assert.assertEquals((Object)"acbd18db4cc2f85cedef654fccc4a4d8", (Object)sendMessageResult.getMD5OfMessageBody());
        Assert.assertEquals((Object)"23bf3e5b587065b0cfbe95761641595a", (Object)sendMessageResult.getMD5OfMessageAttributes());
        ReceiveMessageResult messageResult = clientSQS.receiveMessage(queueUrl);
        Assert.assertNotNull((Object)messageResult);
    }
}

