/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.services.lambda.model.Concurrency;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class ConcurrencyJsonUnmarshaller
implements Unmarshaller<Concurrency, JsonUnmarshallerContext> {
    private static ConcurrencyJsonUnmarshaller instance;

    @Override
    public Concurrency unmarshall(JsonUnmarshallerContext context) throws Exception {
        Concurrency concurrency = new Concurrency();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ReservedConcurrentExecutions", targetDepth)) {
                    context.nextToken();
                    concurrency.setReservedConcurrentExecutions(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return concurrency;
    }

    public static ConcurrencyJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConcurrencyJsonUnmarshaller();
        }
        return instance;
    }
}

