/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sqs.model.UntagQueueRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UntagQueueRequestMarshaller
implements Marshaller<Request<UntagQueueRequest>, UntagQueueRequest> {
    @Override
    public Request<UntagQueueRequest> marshall(UntagQueueRequest untagQueueRequest) {
        if (untagQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UntagQueueRequest> request = new DefaultRequest<UntagQueueRequest>(untagQueueRequest, "AmazonSQS");
        request.addParameter("Action", "UntagQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (untagQueueRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(untagQueueRequest.getQueueUrl()));
        }
        if (!untagQueueRequest.getTagKeys().isEmpty() || !((SdkInternalList)untagQueueRequest.getTagKeys()).isAutoConstruct()) {
            SdkInternalList tagKeysList = (SdkInternalList)untagQueueRequest.getTagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKey." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        return request;
    }
}

