/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.apache.http.client.protocol;

import com.amazonaws.thirdparty.apache.http.HttpEntity;
import com.amazonaws.thirdparty.apache.http.HttpEntityEnclosingRequest;
import com.amazonaws.thirdparty.apache.http.HttpException;
import com.amazonaws.thirdparty.apache.http.HttpRequest;
import com.amazonaws.thirdparty.apache.http.HttpRequestInterceptor;
import com.amazonaws.thirdparty.apache.http.HttpVersion;
import com.amazonaws.thirdparty.apache.http.ProtocolVersion;
import com.amazonaws.thirdparty.apache.http.annotation.Contract;
import com.amazonaws.thirdparty.apache.http.annotation.ThreadingBehavior;
import com.amazonaws.thirdparty.apache.http.client.config.RequestConfig;
import com.amazonaws.thirdparty.apache.http.client.protocol.HttpClientContext;
import com.amazonaws.thirdparty.apache.http.protocol.HttpContext;
import com.amazonaws.thirdparty.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

