/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.Localstack;
import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.TestUtils;
import cloud.localstack.docker.LocalstackDockerExtension;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazon.sqs.javamessaging.SQSConnection;
import com.amazon.sqs.javamessaging.SQSConnectionFactory;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import java.util.HashMap;
import java.util.List;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
@ExtendWith(value={LocalstackDockerExtension.class})
@LocalstackDockerProperties(randomizePorts=true, services={"sqs"})
public class DockerOnlySQSFunctionalityTest {
    @Test
    @org.junit.jupiter.api.Test
    public void testKinesisNotRunning() {
        Throwable throwable = Assertions.catchThrowable(() -> TestUtils.getClientKinesis().listStreams());
        Assertions.assertThat((Throwable)throwable).isInstanceOf(SdkClientException.class);
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testDynamoNotRunning() {
        Throwable throwable = Assertions.catchThrowable(() -> TestUtils.getClientDynamoDB().listTables());
        Assertions.assertThat((Throwable)throwable).isInstanceOf(SdkClientException.class);
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testS3NotRunning() {
        Throwable throwable = Assertions.catchThrowable(() -> TestUtils.getClientS3().createBucket("test-bucket"));
        Assertions.assertThat((Throwable)throwable).isInstanceOf(SdkClientException.class);
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testSQSRunning() throws Exception {
        AmazonSQS client = TestUtils.getClientSQS();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("DelaySeconds", "0");
        attributeMap.put("MaximumMessageSize", "262144");
        attributeMap.put("MessageRetentionPeriod", "1209600");
        attributeMap.put("ReceiveMessageWaitTimeSeconds", "20");
        attributeMap.put("VisibilityTimeout", "30");
        CreateQueueRequest createQueueRequest = new CreateQueueRequest("test-queue").withAttributes(attributeMap);
        client.createQueue(createQueueRequest);
        ListQueuesResult listQueuesResult = client.listQueues();
        Assertions.assertThat((List)listQueuesResult.getQueueUrls()).hasSize(1);
        SQSConnection connection = this.createSQSConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test-queue");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("Hello World!");
        producer.send((Message)message);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage received = (TextMessage)consumer.receive();
        Assertions.assertThat((String)received.getText()).isEqualTo((Object)"Hello World!");
        consumer.close();
        producer.close();
        connection.close();
    }

    private SQSConnection createSQSConnection() throws Exception {
        SQSConnectionFactory connectionFactory = SQSConnectionFactory.builder().withEndpoint(Localstack.INSTANCE.getEndpointSQS()).withAWSCredentialsProvider((AWSCredentialsProvider)new AWSStaticCredentialsProvider(TestUtils.TEST_CREDENTIALS)).build();
        return connectionFactory.createConnection();
    }

    static {
        TestUtils.setEnv((String)"AWS_CBOR_DISABLE", (String)"1");
    }
}

