/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.testcontainers;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class TestContainersSqsTest {
    private static final String DOCKER_IMAGE_NAME = "localstack/localstack:latest";
    private static final int SQS_PORT = 4576;
    private AmazonSQS amazonSQS;
    private GenericContainer<?> genericContainer;

    @Before
    public void before() {
        this.startDockerImage();
        this.createSqsClient();
    }

    @After
    public void after() {
        this.genericContainer.stop();
    }

    private void createSqsClient() {
        Integer mappedPort = this.genericContainer.getMappedPort(4576);
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration("http://localhost:" + mappedPort, "us-east-1");
        AWSStaticCredentialsProvider awsStaticCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("accesskey", "secretkey"));
        this.amazonSQS = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withEndpointConfiguration(endpointConfiguration)).withCredentials((AWSCredentialsProvider)awsStaticCredentialsProvider)).build();
    }

    @Test
    public void sendAndReceiveMessageTest() {
        CreateQueueResult queue = this.amazonSQS.createQueue("test-queue");
        String queueUrl = queue.getQueueUrl();
        String messageBody = "test-message";
        SendMessageResult sendMessageResult = this.amazonSQS.sendMessage(queueUrl, "test-message");
        Assert.assertNotNull((Object)sendMessageResult);
        String messageId = sendMessageResult.getMessageId();
        Assert.assertNotNull((Object)messageId);
        ReceiveMessageResult messageResult = this.amazonSQS.receiveMessage(queueUrl);
        Assert.assertNotNull((Object)messageResult);
        List messages = messageResult.getMessages();
        Assert.assertNotNull((Object)messages);
        Assert.assertEquals((long)1L, (long)messages.size());
        Message message = (Message)messages.get(0);
        Assert.assertEquals((Object)messageId, (Object)message.getMessageId());
        Assert.assertEquals((Object)"test-message", (Object)message.getBody());
    }

    private void startDockerImage() {
        this.genericContainer = new GenericContainer(DOCKER_IMAGE_NAME).withExposedPorts(new Integer[]{4576}).waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*Ready\\.\n"));
        this.genericContainer.start();
    }
}

