/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LambdaExecutor;
import cloud.localstack.lambda.KinesisEventParser;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class KinesisEventMappingTest {
    @Test
    public void testKinesisRecord() throws Exception {
        String fileContent = LambdaExecutor.readFile((String)"src/test/resources/KinesisEventLambda.json");
        ObjectMapper reader = new ObjectMapper();
        reader.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        reader.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map map = (Map)reader.readerFor(Map.class).readValue(fileContent);
        List records = (List)LambdaExecutor.get((Map)map, (String)"Records");
        KinesisEvent inputObject = KinesisEventParser.parse((List)records);
        Assert.assertNotNull((Object)inputObject);
        Assert.assertEquals((long)1L, (long)inputObject.getRecords().size());
        KinesisEvent.KinesisEventRecord record = (KinesisEvent.KinesisEventRecord)inputObject.getRecords().get(0);
        Assert.assertEquals((Object)"us-east-2", (Object)record.getAwsRegion());
        Assert.assertEquals((Object)"aws:kinesis", (Object)record.getEventSource());
        Assert.assertEquals((Object)"shardId-000000000006:49590338271490256608559692538361571095921575989136588898", (Object)record.getEventID());
        Assert.assertEquals((Object)"arn:aws:kinesis:us-east-2:123456789012:stream/lambda-stream", (Object)record.getEventSourceARN());
        Assert.assertEquals((Object)"aws:kinesis:record", (Object)record.getEventName());
        Assert.assertEquals((Object)"arn:aws:iam::123456789012:role/lambda-role", (Object)record.getInvokeIdentityArn());
        KinesisEvent.Record kinesisRecord = record.getKinesis();
        Assert.assertEquals((Object)"1.0", (Object)kinesisRecord.getKinesisSchemaVersion());
        Assert.assertEquals((Object)"1", (Object)kinesisRecord.getPartitionKey());
        Assert.assertEquals((Object)"49590338271490256608559692538361571095921575989136588898", (Object)kinesisRecord.getSequenceNumber());
        Assert.assertEquals((Object)ByteBuffer.wrap("Hello, this is a test.".getBytes()), (Object)kinesisRecord.getData());
        Assert.assertNotNull((Object)kinesisRecord.getApproximateArrivalTimestamp());
    }
}

