/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv1.TestUtils;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.ListUsersRequest;
import com.amazonaws.services.identitymanagement.model.ListUsersResult;
import com.amazonaws.services.identitymanagement.model.User;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
@LocalstackDockerProperties(services={"iam"}, ignoreDockerRunErrors=true)
public class IAMTest {
    @Test
    public void testUserCreation() throws Exception {
        AmazonIdentityManagement iamClient = TestUtils.getClientIAM();
        String username = UUID.randomUUID().toString();
        CreateUserRequest createUserRequest = new CreateUserRequest(username);
        iamClient.createUser(createUserRequest);
        ListUsersRequest listUsersRequest = new ListUsersRequest();
        ListUsersResult response = iamClient.listUsers(listUsersRequest);
        boolean userFound = false;
        for (User user : response.getUsers()) {
            if (!user.getUserName().equals(username)) continue;
            userFound = true;
            break;
        }
        Assert.assertEquals((Object)true, (Object)userFound);
    }

    @Test
    public void testIAMListUserPagination() throws Exception {
        AmazonIdentityManagement iamClient = TestUtils.getClientIAM();
        String username = UUID.randomUUID().toString();
        CreateUserRequest createUserRequest = new CreateUserRequest(username);
        iamClient.createUser(createUserRequest);
        AtomicBoolean userFound = new AtomicBoolean(false);
        iamClient.listUsers().getUsers().forEach(user -> {
            if (user.getUserName().equals(username)) {
                userFound.set(true);
            }
        });
        Assertions.assertTrue((boolean)userFound.get());
    }
}

