/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.Localstack;
import cloud.localstack.docker.PortMapping;
import cloud.localstack.docker.command.ExecCommand;
import cloud.localstack.docker.command.ListImagesCommand;
import cloud.localstack.docker.command.LogCommand;
import cloud.localstack.docker.command.PortCommand;
import cloud.localstack.docker.command.PullCommand;
import cloud.localstack.docker.command.RunCommand;
import cloud.localstack.docker.command.StopCommand;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Container {
    private static final Logger LOG = Logger.getLogger(Container.class.getName());
    private static final String LOCALSTACK_NAME = "localstack/localstack";
    private static final String LOCALSTACK_TAG = "latest";
    private static final String LOCALSTACK_PORT_EDGE = "4566";
    private static final String LOCALSTACK_PORT_ELASTICSEARCH = "4571";
    private static final int MAX_PORT_CONNECTION_ATTEMPTS = 10;
    private static final int MAX_LOG_COLLECTION_ATTEMPTS = 120;
    private static final long POLL_INTERVAL = 1000L;
    private static final int NUM_LOG_LINES = 100;
    private static final String ENV_DEBUG = "DEBUG";
    private static final String ENV_USE_SSL = "USE_SSL";
    private static final String ENV_DEBUG_DEFAULT = "1";
    public static final String LOCALSTACK_EXTERNAL_HOSTNAME = "HOSTNAME_EXTERNAL";
    private static final String DEFAULT_CONTAINER_ID = "localstack_main";
    private final String containerId;
    private final List<PortMapping> ports;
    private boolean startedByUs;

    public static Container createLocalstackContainer(String externalHostName, boolean pullNewImage, boolean randomizePorts, String imageName, String imageTag, String portEdge, String portElasticSearch, Map<String, String> environmentVariables, Map<Integer, Integer> portMappings, Map<String, String> bindMounts, String platform) {
        environmentVariables = environmentVariables == null ? Collections.emptyMap() : environmentVariables;
        bindMounts = bindMounts == null ? Collections.emptyMap() : bindMounts;
        portMappings = portMappings == null ? Collections.emptyMap() : portMappings;
        String imageNameOrDefault = imageName == null ? LOCALSTACK_NAME : imageName;
        String fullImageName = imageNameOrDefault + ":" + (imageTag == null ? LOCALSTACK_TAG : imageTag);
        boolean imageExists = new ListImagesCommand().execute().contains(fullImageName);
        String fullPortEdge = (portEdge == null ? LOCALSTACK_PORT_EDGE : portEdge) + ":" + LOCALSTACK_PORT_EDGE;
        String fullPortElasticSearch = (portElasticSearch == null ? LOCALSTACK_PORT_ELASTICSEARCH : portElasticSearch) + ":" + LOCALSTACK_PORT_ELASTICSEARCH;
        if (pullNewImage || !imageExists) {
            LOG.info(String.format("Pulling image %s", fullImageName));
            new PullCommand(imageNameOrDefault, imageTag).execute();
        }
        RunCommand runCommand = new RunCommand(imageNameOrDefault, imageTag).withExposedPorts(fullPortEdge, randomizePorts).withExposedPorts(fullPortElasticSearch, randomizePorts).withEnvironmentVariable(LOCALSTACK_EXTERNAL_HOSTNAME, externalHostName).withEnvironmentVariable(ENV_DEBUG, ENV_DEBUG_DEFAULT).withEnvironmentVariable(ENV_USE_SSL, Localstack.useSSL() ? ENV_DEBUG_DEFAULT : "0").withEnvironmentVariables(environmentVariables).withBindMountedVolumes(bindMounts);
        if (!StringUtils.isEmpty((CharSequence)platform)) {
            runCommand = runCommand.withPlatform(platform);
        }
        for (Integer port : portMappings.keySet()) {
            runCommand = runCommand.withExposedPorts(String.valueOf(port), false);
        }
        String containerId = runCommand.execute();
        LOG.info("Started container: " + containerId);
        Container result = Container.getRunningLocalstackContainer(containerId);
        result.startedByUs = true;
        return result;
    }

    public static Container getRunningLocalstackContainer() {
        return Container.getRunningLocalstackContainer(DEFAULT_CONTAINER_ID);
    }

    public static Container getRunningLocalstackContainer(String containerId) {
        List<PortMapping> portMappingsList = new PortCommand(containerId).execute();
        return new Container(containerId, portMappingsList);
    }

    private Container(String containerId, List<PortMapping> ports) {
        this.containerId = containerId;
        this.ports = Collections.unmodifiableList(ports);
    }

    public int getExternalPortFor(int internalPort) {
        return this.ports.stream().filter(port -> port.getInternalPort() == internalPort).map(PortMapping::getExternalPort).findFirst().orElseThrow(() -> new IllegalArgumentException("Port: " + internalPort + " does not exist"));
    }

    public void waitForAllPorts(String ip) {
        this.ports.forEach(port -> this.waitForPort(ip, (PortMapping)port));
    }

    private void waitForPort(String ip, PortMapping port) {
        int attempts = 0;
        do {
            if (!this.isPortOpen(ip, port)) continue;
            return;
        } while (++attempts < 10);
        throw new IllegalStateException("Could not open port:" + port.getExternalPort() + " on ip:" + port.getIp());
    }

    private boolean isPortOpen(String ip, PortMapping port) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(ip, port.getExternalPort()), 1000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public boolean isRunning() {
        try {
            new PortCommand(this.containerId).execute();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void waitForLogToken(Pattern pattern) {
        int attempts = 0;
        do {
            if (this.logContainsPattern(pattern)) {
                return;
            }
            this.waitForLogs();
        } while (++attempts < 120);
        String logs = this.getContainerLogs();
        throw new IllegalStateException("Could not find token: " + pattern + " in Docker logs: " + logs);
    }

    private boolean logContainsPattern(Pattern pattern) {
        String logs = this.getContainerLogs();
        return pattern.matcher(logs).find();
    }

    private String getContainerLogs() {
        return new LogCommand(this.containerId).withNumberOfLines(100).execute();
    }

    private void waitForLogs() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
        if (!this.startedByUs) {
            return;
        }
        new StopCommand(this.containerId).execute();
        LOG.info("Stopped container: " + this.containerId);
    }

    public String executeCommand(List<String> command) {
        return new ExecCommand(this.containerId).execute(command);
    }

    String getContainerId() {
        return this.containerId;
    }
}

