/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.Localstack;
import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv2.TestUtils;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import java.net.URI;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import software.amazon.awssdk.services.qldb.QldbAsyncClient;
import software.amazon.awssdk.services.qldb.model.CreateLedgerRequest;
import software.amazon.awssdk.services.qldb.model.CreateLedgerResponse;
import software.amazon.awssdk.services.qldbsession.QldbSessionClient;
import software.amazon.awssdk.services.qldbsession.QldbSessionClientBuilder;
import software.amazon.qldb.QldbDriver;
import software.amazon.qldb.Result;

@RunWith(value=LocalstackTestRunner.class)
@LocalstackDockerProperties(ignoreDockerRunErrors=true)
public class ProFeaturesSDKV2Test {
    @Test
    public void testQueryQLDBLedger() throws Exception {
        if (System.getenv("LOCALSTACK_API_KEY") == null) {
            return;
        }
        QldbAsyncClient client = TestUtils.getClientQLDBAsyncV2();
        String ledgerName = "l123";
        CreateLedgerRequest request = (CreateLedgerRequest)CreateLedgerRequest.builder().name(ledgerName).build();
        CreateLedgerResponse ledger = (CreateLedgerResponse)client.createLedger(request).get();
        Assert.assertEquals((Object)ledger.name(), (Object)ledgerName);
        QldbDriver driver = QldbDriver.builder().ledger(ledgerName).sessionClientBuilder((QldbSessionClientBuilder)QldbSessionClient.builder().endpointOverride(new URI(Localstack.INSTANCE.getEndpointQLDB()))).build();
        String tableName1 = "table1";
        String tableName2 = "table2";
        driver.execute(txn -> txn.execute("CREATE TABLE " + tableName1));
        driver.execute(txn -> txn.execute("CREATE TABLE " + tableName2));
        ArrayList tableNames = new ArrayList();
        driver.getTableNames().forEach(tableNames::add);
        Assert.assertTrue((boolean)tableNames.contains(tableName1));
        Assert.assertTrue((boolean)tableNames.contains(tableName2));
        String query = "SELECT VALUE name FROM information_schema.user_tables WHERE status = 'ACTIVE'";
        Result result = (Result)driver.execute(txn -> txn.execute(query));
        Assert.assertNotNull((Object)result);
        ArrayList tableNames2 = new ArrayList();
        result.forEach(tableNames2::add);
        Assert.assertTrue((boolean)tableNames2.contains(tableName1));
        Assert.assertTrue((boolean)tableNames2.contains(tableName2));
    }
}

