/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DockerExe {
    private static final int DEFAULT_WAIT_TIME_MINUTES = 2;
    private static final List<String> POSSIBLE_EXE_LOCATIONS = Arrays.asList(System.getenv("DOCKER_LOCATION"), "C:/program files/docker/docker/resources/bin/docker.exe", "C:/program files/docker/docker/resources/docker.exe", "/usr/local/bin/docker", "/usr/bin/docker");
    private final String exeLocation = this.getDockerExeLocation();

    private String getDockerExeLocation() {
        return POSSIBLE_EXE_LOCATIONS.stream().filter(Objects::nonNull).filter(name -> new File((String)name).exists()).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find docker executable."));
    }

    public String execute(List<String> args) {
        return this.execute(args, 2);
    }

    public String execute(List<String> args, int waitTimeoutMinutes) {
        return this.execute(args, waitTimeoutMinutes, Arrays.asList(new Integer[0]));
    }

    public String execute(List<String> args, int waitTimeoutMinutes, List<Integer> errorCodes) {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.exeLocation);
            command.addAll(args);
            Process process = new ProcessBuilder(new String[0]).command(command).redirectErrorStream(true).start();
            ExecutorService exec = Executors.newSingleThreadExecutor();
            Future<String> outputFuture = exec.submit(() -> this.handleOutput(process));
            String output = outputFuture.get(waitTimeoutMinutes, TimeUnit.MINUTES);
            process.waitFor(waitTimeoutMinutes, TimeUnit.MINUTES);
            int code = process.exitValue();
            exec.shutdown();
            if (errorCodes.contains(code)) {
                throw new RuntimeException("Error status code " + code + " returned from process. Output: " + output);
            }
            return output;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("Failed to execute command", ex);
        }
    }

    private String handleOutput(Process process) {
        BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        return stdout.lines().collect(Collectors.joining(System.lineSeparator()));
    }
}

