/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv2.LocalTestUtilSDKV2;
import cloud.localstack.awssdkv2.TestUtils;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import cloud.localstack.sample.LambdaHandler;
import io.thundra.jexter.junit4.core.sysprop.SystemPropertySandboxRule;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;

@RunWith(value=LocalstackTestRunner.class)
@LocalstackDockerProperties(ignoreDockerRunErrors=true)
public class BasicFeaturesSDKV2Test {
    @ClassRule
    public static SystemPropertySandboxRule systemPropertySandboxRule = new SystemPropertySandboxRule();

    @BeforeClass
    public static void beforeAll() {
        System.setProperty(SdkSystemSetting.CBOR_ENABLED.property(), "false");
    }

    @Test
    public void testCreateSqsQueueV2() throws Exception {
        String queueName = "test-q-" + UUID.randomUUID().toString();
        CreateQueueRequest request = (CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build();
        SqsAsyncClient sqsClient = TestUtils.getClientSQSAsyncV2();
        CreateQueueResponse queue = (CreateQueueResponse)sqsClient.createQueue(request).get();
        Assert.assertTrue((boolean)queue.queueUrl().contains("000000000000/" + queueName));
    }

    @Test
    public void testCreateKinesisStreamV2() throws Exception {
        String streamName = "test-s-" + UUID.randomUUID().toString();
        KinesisAsyncClient kinesisClient = TestUtils.getClientKinesisAsyncV2();
        CreateStreamRequest request = (CreateStreamRequest)CreateStreamRequest.builder().streamName(streamName).shardCount(Integer.valueOf(1)).build();
        CreateStreamResponse response = (CreateStreamResponse)kinesisClient.createStream(request).get();
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testCreateKinesisRecordV2() throws Exception {
        String streamName = "test-s-" + UUID.randomUUID().toString();
        KinesisAsyncClient kinesisClient = TestUtils.getClientKinesisAsyncV2();
        CreateStreamRequest request = (CreateStreamRequest)CreateStreamRequest.builder().streamName(streamName).shardCount(Integer.valueOf(1)).build();
        CreateStreamResponse response = (CreateStreamResponse)kinesisClient.createStream(request).get();
        Assert.assertNotNull((Object)response);
        SdkBytes payload = SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(String.format("testData-%d", 1).getBytes()));
        PutRecordRequest.Builder putRecordRequest = PutRecordRequest.builder();
        putRecordRequest.streamName(streamName);
        putRecordRequest.data(payload);
        putRecordRequest.partitionKey(String.format("partitionKey-%d", 1));
        Assert.assertNotNull((Object)kinesisClient.putRecord((PutRecordRequest)putRecordRequest.build()));
    }

    @Test
    public void testCreateDynamoDBTable() throws Exception {
        DynamoDbAsyncClient dynamoDbAsyncClient = TestUtils.getClientDyanamoAsyncV2();
        String tableName = "test-s-" + UUID.randomUUID().toString();
        CreateTableRequest createTableRequest = (CreateTableRequest)CreateTableRequest.builder().keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().keyType(KeyType.HASH).attributeName("test").build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("test").attributeType(ScalarAttributeType.S).build()}).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(5L)).writeCapacityUnits(Long.valueOf(5L)).build()).tableName(tableName).build();
        CreateTableResponse response = (CreateTableResponse)dynamoDbAsyncClient.createTable(createTableRequest).get();
        Assert.assertNotNull((Object)response);
        dynamoDbAsyncClient.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().tableName(tableName).build());
    }

    @Test
    public void testS3CreateListBuckets() throws Exception {
        String bucketName = "test-b-" + UUID.randomUUID().toString();
        S3AsyncClient s3Client = TestUtils.getClientS3AsyncV2();
        CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
        CreateBucketResponse response = (CreateBucketResponse)s3Client.createBucket(request).get();
        Assert.assertNotNull((Object)response);
        ListBucketsRequest listRequest = (ListBucketsRequest)ListBucketsRequest.builder().build();
        ListBucketsResponse buckets = (ListBucketsResponse)s3Client.listBuckets(listRequest).get();
        Bucket bucket = buckets.buckets().stream().filter(b -> b.name().equals(bucketName)).findFirst().get();
        Assert.assertNotNull((Object)bucket);
    }

    @Test
    public void testSendSNSMessage() throws Exception {
        String topicName = "test-t-" + UUID.randomUUID().toString();
        SnsAsyncClient clientSNS = TestUtils.getClientSNSAsyncV2();
        CreateTopicResponse createTopicResponse = (CreateTopicResponse)clientSNS.createTopic((CreateTopicRequest)CreateTopicRequest.builder().name(topicName).build()).get();
        String topicArn = createTopicResponse.topicArn();
        Assert.assertNotNull((Object)topicArn);
        PublishRequest publishRequest = (PublishRequest)PublishRequest.builder().topicArn(topicArn).subject("test subject").message("message test.").build();
        PublishResponse publishResponse = (PublishResponse)clientSNS.publish(publishRequest).get();
        Assert.assertNotNull((Object)publishResponse.messageId());
    }

    @Test
    public void testGetSsmParameter() throws Exception {
        SsmAsyncClient clientSsm = TestUtils.getClientSSMAsyncV2();
        String paramName = "param-" + UUID.randomUUID().toString();
        clientSsm.putParameter((PutParameterRequest)PutParameterRequest.builder().name(paramName).value("testvalue").build()).join();
        CompletableFuture getParameterResponse = clientSsm.getParameter((GetParameterRequest)GetParameterRequest.builder().name(paramName).build());
        String parameterValue = ((GetParameterResponse)getParameterResponse.get()).parameter().value();
        Assert.assertNotNull((Object)parameterValue);
        Assert.assertEquals((Object)"testvalue", (Object)parameterValue);
    }

    @Test
    public void testGetSecretsManagerSecret() throws Exception {
        SecretsManagerAsyncClient clientSecretsManager = TestUtils.getClientSecretsManagerAsyncV2();
        String secretName = "test-s-" + UUID.randomUUID().toString();
        clientSecretsManager.createSecret((CreateSecretRequest)CreateSecretRequest.builder().name(secretName).secretString("secretcontent").build()).join();
        CompletableFuture getSecretResponse = clientSecretsManager.getSecretValue((GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build());
        String secretValue = ((GetSecretValueResponse)getSecretResponse.get()).secretString();
        Assert.assertNotNull((Object)secretValue);
        Assert.assertEquals((Object)"secretcontent", (Object)secretValue);
        clientSecretsManager.deleteSecret((DeleteSecretRequest)DeleteSecretRequest.builder().secretId(secretName).build());
    }

    @Test
    public void testGetSecretAsParam() throws Exception {
        SsmAsyncClient clientSsm = TestUtils.getClientSSMAsyncV2();
        SecretsManagerAsyncClient clientSecretsManager = TestUtils.getClientSecretsManagerAsyncV2();
        String secretName = "test-s-" + UUID.randomUUID().toString();
        clientSecretsManager.createSecret((CreateSecretRequest)CreateSecretRequest.builder().name(secretName).secretString("secretcontent").build()).join();
        CompletableFuture getParameterResponse = clientSsm.getParameter((GetParameterRequest)GetParameterRequest.builder().name("/aws/reference/secretsmanager/" + secretName).build());
        String parameterValue = ((GetParameterResponse)getParameterResponse.get()).parameter().value();
        Assert.assertNotNull((Object)parameterValue);
        Assert.assertEquals((Object)"secretcontent", (Object)parameterValue);
        clientSecretsManager.deleteSecret((DeleteSecretRequest)DeleteSecretRequest.builder().secretId(secretName).build());
    }

    @Test
    public void testCWPutMetrics() throws Exception {
        CloudWatchAsyncClient clientCW = TestUtils.getClientCloudWatchAsyncV2();
        Dimension dimension = (Dimension)Dimension.builder().name("UNIQUE_PAGES").value("URLS").build();
        String time = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Instant instant = Instant.parse(time);
        double dataPoint = 1.23423;
        MetricDatum datum = (MetricDatum)MetricDatum.builder().metricName("PAGES_VISITED").unit(StandardUnit.NONE).value(Double.valueOf(dataPoint)).timestamp(instant).dimensions(new Dimension[]{dimension}).build();
        PutMetricDataRequest request = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace("SITE/TRAFFIC").metricData(new MetricDatum[]{datum}).build();
        PutMetricDataResponse response = (PutMetricDataResponse)clientCW.putMetricData(request).get();
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testCWMultipleDimentionsAndMetrics() throws Exception {
        CloudWatchAsyncClient clientCW = TestUtils.getClientCloudWatchAsyncV2();
        ArrayList<Dimension> awsDimensionList = new ArrayList<Dimension>();
        for (int i = 0; i < 10; ++i) {
            awsDimensionList.add((Dimension)Dimension.builder().name("UNIQUE_PAGES" + i).value("URLS" + i).build());
        }
        String time = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Instant instant = Instant.parse(time);
        double dataPoint = 1.23423;
        ArrayList<MetricDatum> metrics = new ArrayList<MetricDatum>();
        for (int i = 0; i < 20; ++i) {
            metrics.add((MetricDatum)MetricDatum.builder().metricName("PAGES_VISITED").unit(StandardUnit.NONE).value(Double.valueOf(dataPoint)).timestamp(instant).dimensions(awsDimensionList).build());
        }
        PutMetricDataRequest request = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace("SITE/TRAFFIC").metricData(metrics).build();
        PutMetricDataResponse response = (PutMetricDataResponse)clientCW.putMetricData(request).get();
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testLambdaCreateListFunctions() throws Exception {
        String functionName = "test-f-" + UUID.randomUUID().toString();
        LambdaAsyncClient lambdaClient = TestUtils.getClientLambdaAsyncV2();
        CreateFunctionRequest createFunctionRequest = (CreateFunctionRequest)CreateFunctionRequest.builder().functionName(functionName).runtime(Runtime.JAVA8).role("r1").code(LocalTestUtilSDKV2.createFunctionCode(LambdaHandler.class)).handler(LambdaHandler.class.getName()).build();
        CreateFunctionResponse response = (CreateFunctionResponse)lambdaClient.createFunction(createFunctionRequest).get();
        Assert.assertNotNull((Object)response);
        ListFunctionsResponse functions = (ListFunctionsResponse)lambdaClient.listFunctions().get();
        FunctionConfiguration function = functions.functions().stream().filter(f -> f.functionName().equals(functionName)).findFirst().get();
        Assert.assertNotNull((Object)function);
    }

    @Test
    public void testIAMUserCreation() throws Exception {
        IamAsyncClient iamClient = TestUtils.getClientIamAsyncV2();
        String username = UUID.randomUUID().toString();
        CreateUserRequest createUserRequest = (CreateUserRequest)CreateUserRequest.builder().userName(username).build();
        iamClient.createUser(createUserRequest).join();
        boolean userFound = false;
        List users = ((ListUsersResponse)iamClient.listUsers().get()).users();
        for (int i = 0; i < users.size(); ++i) {
            if (!((User)users.get(i)).userName().equals(username)) continue;
            userFound = true;
            break;
        }
        Assert.assertTrue((boolean)userFound);
    }

    @Test
    public void testIAMListUserPagination() throws Exception {
        IamAsyncClient iamClient = TestUtils.getClientIamAsyncV2();
        String username = UUID.randomUUID().toString();
        CreateUserRequest createUserRequest = (CreateUserRequest)CreateUserRequest.builder().userName(username).build();
        iamClient.createUser(createUserRequest).join();
        AtomicBoolean userFound = new AtomicBoolean(false);
        iamClient.listUsersPaginator().users().subscribe(user -> {
            if (user.userName().equals(username)) {
                userFound.set(true);
            }
        });
        TimeUnit.SECONDS.sleep(2L);
        Assert.assertTrue((boolean)userFound.get());
    }
}

