/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.Localstack;
import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv2.TestUtils;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazon.ion.IonString;
import com.amazon.ion.IonStruct;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.system.IonSystemBuilder;
import com.fasterxml.jackson.dataformat.ion.IonObjectMapper;
import com.fasterxml.jackson.dataformat.ion.ionvalue.IonValueMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import software.amazon.awssdk.services.qldb.QldbAsyncClient;
import software.amazon.awssdk.services.qldb.model.CreateLedgerRequest;
import software.amazon.awssdk.services.qldb.model.CreateLedgerResponse;
import software.amazon.awssdk.services.qldb.model.DeleteLedgerRequest;
import software.amazon.awssdk.services.qldbsession.QldbSessionClient;
import software.amazon.awssdk.services.qldbsession.QldbSessionClientBuilder;
import software.amazon.qldb.QldbDriver;
import software.amazon.qldb.Result;

@RunWith(value=LocalstackTestRunner.class)
@LocalstackDockerProperties(ignoreDockerRunErrors=true)
public class ProFeaturesSDKV2Test {
    public static final IonSystem SYSTEM = IonSystemBuilder.standard().build();
    public static final IonObjectMapper MAPPER = new IonValueMapper(SYSTEM);
    private static final Logger LOG = Logger.getLogger(ProFeaturesSDKV2Test.class.getName());

    @Test
    public void testCreateListTables() throws Exception {
        if (!this.isProEnabled()) {
            return;
        }
        String ledgerName = "l123";
        QldbAsyncClient client = TestUtils.getClientQLDBAsyncV2();
        String tableName1 = "table1";
        String tableName2 = "table2";
        this.createLedgerAndTables(ledgerName, tableName1, tableName2);
        QldbDriver driver = this.getDriver(ledgerName);
        ArrayList tableNames = new ArrayList();
        driver.getTableNames().forEach(tableNames::add);
        Assert.assertTrue((boolean)tableNames.contains(tableName1));
        Assert.assertTrue((boolean)tableNames.contains(tableName2));
        String query = "SELECT VALUE name FROM information_schema.user_tables WHERE status = 'ACTIVE'";
        Result result = (Result)driver.execute(txn -> txn.execute(query));
        Assert.assertNotNull((Object)result);
        ArrayList tableNames2 = new ArrayList();
        result.forEach(v -> tableNames2.add(((IonString)v).stringValue()));
        Assert.assertTrue((boolean)tableNames2.contains(tableName1));
        Assert.assertTrue((boolean)tableNames2.contains(tableName2));
        client.deleteLedger((DeleteLedgerRequest)DeleteLedgerRequest.builder().name(ledgerName).build());
    }

    @Test
    public void testCreateListIndexes() throws Exception {
        if (!this.isProEnabled()) {
            return;
        }
        String ledgerName = "l123";
        String tableName1 = "table1";
        QldbDriver driver = this.getDriver(ledgerName);
        this.createLedgerAndTables(ledgerName, tableName1);
        String query1 = "CREATE INDEX on " + tableName1 + "(attr1)";
        driver.execute(txn -> txn.execute(query1));
        String query2 = "SELECT VALUE indexes FROM information_schema.user_tables info, info.indexes indexes";
        Result indexQueryResult = (Result)driver.execute(txn -> txn.execute(query2));
        Set result = StreamSupport.stream(indexQueryResult.spliterator(), false).map(v -> (IonStruct)v).map(s -> ((IonString)s.get("expr")).stringValue()).collect(Collectors.toSet());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("[attr1]")), result);
        this.cleanUp(ledgerName);
    }

    @Test
    public void testUpdateQueryDataTypes() throws Exception {
        if (!this.isProEnabled()) {
            return;
        }
        LOG.info("Running testUpdateQueryDataTypes to check QLDB query data types...");
        String tableName1 = "Wallet";
        String ledgerName = "l123";
        this.createLedgerAndTables(ledgerName, tableName1);
        QldbDriver driver = this.getDriver(ledgerName);
        Wallet wallet = new Wallet();
        wallet.setId("1");
        wallet.setDescription("my personal wallet");
        wallet.setBalance(25.0);
        wallet.setTags((Map<String, String>)ImmutableMap.of((Object)"meta", (Object)"true"));
        wallet.setType(WalletType.PERSONAL);
        driver.execute(txn -> {
            try {
                txn.execute("INSERT INTO Wallet ?", new IonValue[]{MAPPER.writeValueAsIonValue((Object)wallet)});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        wallet.setDescription("my test wallet");
        wallet.setBalance(26.12);
        wallet.setTags((Map<String, String>)ImmutableMap.of());
        wallet.setType(WalletType.BUSINESS);
        String query = "UPDATE Wallet \nSET description = ?,\n balance = ?,\n tags = ?,\n type = ?\n WHERE id = ?";
        driver.execute(txn -> {
            try {
                return txn.execute(query, new IonValue[]{MAPPER.writeValueAsIonValue((Object)wallet.getDescription()), MAPPER.writeValueAsIonValue((Object)wallet.getBalance()), MAPPER.writeValueAsIonValue(wallet.getTags()), MAPPER.writeValueAsIonValue((Object)wallet.getType()), MAPPER.writeValueAsIonValue((Object)wallet.getId())});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        Result queryResult = (Result)driver.execute(txn -> {
            try {
                return txn.execute("SELECT * FROM Wallet WHERE id = ?", new IonValue[]{MAPPER.writeValueAsIonValue((Object)wallet.getId())});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        Set result = StreamSupport.stream(queryResult.spliterator(), false).map(v -> (IonStruct)v).map(s -> s.get("balance").toString()).collect(Collectors.toSet());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("26.12")), result);
        this.cleanUp(ledgerName);
    }

    @Test
    public void testCreateDropTable() throws Exception {
        if (!this.isProEnabled()) {
            return;
        }
        LOG.info("Running test testCreateDropTable() ...");
        String ledgerName = "l123";
        QldbDriver driver = this.createLedgerAndGetDriver(ledgerName, new String[0]);
        driver.execute(txn -> txn.execute("CREATE TABLE A"));
        driver.execute(txn -> txn.execute("DROP TABLE A"));
        Set tableNames = StreamSupport.stream(driver.getTableNames().spliterator(), false).collect(Collectors.toSet());
        Assert.assertTrue((boolean)tableNames.isEmpty());
    }

    private QldbDriver createLedgerAndGetDriver(String ledgerName, String ... tableNames) throws Exception {
        this.createLedgerAndTables(ledgerName, tableNames);
        return this.getDriver(ledgerName);
    }

    private void createLedgerAndTables(String ledgerName, String ... tableNames) throws Exception {
        QldbAsyncClient client = TestUtils.getClientQLDBAsyncV2();
        CreateLedgerRequest request = (CreateLedgerRequest)CreateLedgerRequest.builder().name(ledgerName).build();
        CreateLedgerResponse ledger = (CreateLedgerResponse)client.createLedger(request).get();
        Assert.assertEquals((Object)ledger.name(), (Object)ledgerName);
        QldbDriver driver = this.getDriver(ledgerName);
        for (String tableName : tableNames) {
            driver.execute(txn -> txn.execute("CREATE TABLE " + tableName));
        }
    }

    private QldbDriver getDriver(String ledgerName) throws Exception {
        return QldbDriver.builder().ledger(ledgerName).sessionClientBuilder((QldbSessionClientBuilder)QldbSessionClient.builder().endpointOverride(new URI(Localstack.INSTANCE.getEndpointQLDB()))).build();
    }

    private void cleanUp(String ledgerName) {
        QldbAsyncClient client = TestUtils.getClientQLDBAsyncV2();
        client.deleteLedger((DeleteLedgerRequest)DeleteLedgerRequest.builder().name(ledgerName).build());
    }

    private boolean isProEnabled() {
        return System.getenv("LOCALSTACK_API_KEY") != null;
    }

    public static class Wallet {
        String id;
        String description;
        double balance;
        Map<String, String> tags;
        WalletType type;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public double getBalance() {
            return this.balance;
        }

        public void setBalance(double balance) {
            this.balance = balance;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        public WalletType getType() {
            return this.type;
        }

        public void setType(WalletType type) {
            this.type = type;
        }
    }

    public static enum WalletType {
        PERSONAL,
        BUSINESS;

    }
}

