/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv1;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv1.TestUtils;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.PublishResult;
import javax.jms.JMSException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.modules.junit4.PowerMockRunnerDelegate;

@RunWith(value=PowerMockRunner.class)
@PowerMockRunnerDelegate(value=LocalstackTestRunner.class)
@LocalstackDockerProperties(services={"sns"})
@PrepareForTest(value={AmazonSNS.class, AmazonSNSClientBuilder.class})
@PowerMockIgnore(value={"javax.crypto.*", "org.hamcrest.*", "javax.net.ssl.*", "com.sun.org.apache.xerces.*", "javax.xml.*", "org.xml.*", "javax.management.*", "javax.security.*", "org.w3c.*"})
public class PowerMockExampleTest {
    private static final String TOPIC = "topic";

    @Before
    public void mock() {
        AmazonSNS mockSes = TestUtils.getClientSNS();
        PowerMockito.mockStatic(AmazonSNSClientBuilder.class, (Class[])new Class[0]);
        Mockito.when((Object)AmazonSNSClientBuilder.defaultClient()).thenReturn((Object)mockSes);
    }

    @Test
    public void testSendMessage() throws JMSException {
        AmazonSNS clientSNS = AmazonSNSClientBuilder.defaultClient();
        CreateTopicResult createTopicResult = clientSNS.createTopic(TOPIC);
        PublishResult publishResult = clientSNS.publish(createTopicResult.getTopicArn(), "message");
        Assert.assertNotNull((Object)publishResult);
    }
}

