/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv1;

import cloud.localstack.LambdaExecutor;
import cloud.localstack.awssdkv1.lambda.S3EventParser;
import com.amazonaws.services.lambda.runtime.events.S3Event;
import com.amazonaws.services.s3.event.S3EventNotification;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class S3EventMappingTest {
    static String fileName = "src/test/resources/S3EventLambda.json";

    @Test
    public void testParseS3Event() throws Exception {
        String fileContent = LambdaExecutor.readFile((String)fileName);
        ObjectMapper reader = new ObjectMapper();
        Map map = (Map)reader.reader(Map.class).readValue(fileContent);
        List records = (List)LambdaExecutor.get((Map)map, (String)"Records");
        S3Event s3Event = S3EventParser.parse((List)records);
        S3EventNotification.S3EventNotificationRecord record = (S3EventNotification.S3EventNotificationRecord)s3Event.getRecords().get(0);
        Map expectedResultRecord = (Map)records.get(0);
        Map expS3 = (Map)expectedResultRecord.get("s3");
        Map expBk = (Map)LambdaExecutor.get((Map)expS3, (String)"bucket");
        Map expOi = (Map)LambdaExecutor.get((Map)expBk, (String)"ownerIdentity");
        Assert.assertEquals((String)"eventVersion match", expectedResultRecord.get("eventVersion"), (Object)record.getEventVersion());
        Assert.assertEquals((String)"eventTime match", expectedResultRecord.get("eventTime"), (Object)record.getEventTime().toString());
        Assert.assertEquals((String)"sourceIPAddress match", (Object)LambdaExecutor.get((Map)((Map)expectedResultRecord.get("requestParameters")), (String)"sourceIPAddress"), (Object)record.getRequestParameters().getSourceIPAddress());
        Assert.assertEquals((String)"s3 configurationId match", expS3.get("configurationId"), (Object)record.getS3().getConfigurationId());
        Assert.assertEquals((String)"s3 object versionId match", (Object)LambdaExecutor.get((Map)((Map)expS3.get("object")), (String)"versionId"), (Object)record.getS3().getObject().getVersionId());
        Assert.assertEquals((String)"s3 object eTag match", (Object)LambdaExecutor.get((Map)((Map)expS3.get("object")), (String)"eTag"), (Object)record.getS3().getObject().geteTag());
        Assert.assertEquals((String)"s3 object key match", (Object)LambdaExecutor.get((Map)((Map)expS3.get("object")), (String)"key"), (Object)record.getS3().getObject().getKey());
        Assert.assertEquals((String)"s3 object sequencer match", (Object)LambdaExecutor.get((Map)((Map)expS3.get("object")), (String)"sequencer"), (Object)record.getS3().getObject().getSequencer());
        Assert.assertEquals((String)"s3 object size match", (Object)new Long(LambdaExecutor.get((Map)((Map)expS3.get("object")), (String)"size").toString()), (Object)record.getS3().getObject().getSizeAsLong());
        Assert.assertEquals((String)"s3 ownerEntity principalId match", expOi.get("principalId"), (Object)record.getS3().getBucket().getOwnerIdentity().getPrincipalId());
        Assert.assertEquals((String)"s3 bucket name match", expBk.get("name"), (Object)record.getS3().getBucket().getName());
        Assert.assertEquals((String)"s3 schemaVersion match", expS3.get("s3SchemaVersion"), (Object)record.getS3().getS3SchemaVersion());
        Assert.assertEquals((String)"responseElements x-amz-id-2 match", (Object)LambdaExecutor.get((Map)((Map)expectedResultRecord.get("responseElements")), (String)"x-amz-id-2"), (Object)record.getResponseElements().getxAmzId2());
        Assert.assertEquals((String)"responseElements x-amz-request-id match", (Object)LambdaExecutor.get((Map)((Map)expectedResultRecord.get("responseElements")), (String)"x-amz-request-id"), (Object)record.getResponseElements().getxAmzRequestId());
        Assert.assertEquals((String)"awsRegion match", expectedResultRecord.get("awsRegion"), (Object)record.getAwsRegion());
        Assert.assertEquals((String)"eventName match", expectedResultRecord.get("eventName"), (Object)record.getEventName());
        Assert.assertEquals((String)"userIdentity principalId", (Object)LambdaExecutor.get((Map)((Map)expectedResultRecord.get("userIdentity")), (String)"principalId"), (Object)record.getUserIdentity().getPrincipalId());
        Assert.assertEquals((String)"eventSource match", expectedResultRecord.get("eventSource"), (Object)record.getEventSource());
    }
}

