/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class LocalTestUtil {
    protected static ByteBuffer createFunctionByteBuffer(Class<?> clazz, Class<?> ... additionalClasses) throws Exception {
        ByteArrayOutputStream zipOut = new ByteArrayOutputStream();
        ByteArrayOutputStream jarOut = new ByteArrayOutputStream();
        ZipOutputStream zipStream = new ZipOutputStream(zipOut);
        JarOutputStream jarStream = new JarOutputStream(jarOut);
        LocalTestUtil.addClassToJar(clazz, jarStream);
        for (Class<?> _class : additionalClasses) {
            LocalTestUtil.addClassToJar(_class, jarStream);
        }
        JarEntry mfEntry = new JarEntry("META-INF/MANIFEST.MF");
        jarStream.putNextEntry(mfEntry);
        jarStream.closeEntry();
        jarStream.close();
        ZipEntry codeEntry = new ZipEntry("LambdaCode.jar");
        zipStream.putNextEntry(codeEntry);
        zipStream.write(jarOut.toByteArray());
        zipStream.closeEntry();
        zipStream.close();
        return ByteBuffer.wrap(zipOut.toByteArray());
    }

    private static void addClassToJar(Class<?> clazz, JarOutputStream jarStream) throws IOException {
        String resource = clazz.getName().replace(".", File.separator) + ".class";
        JarEntry jarEntry = new JarEntry(resource);
        jarStream.putNextEntry(jarEntry);
        IOUtils.copy((InputStream)LocalTestUtil.class.getResourceAsStream("/" + resource), (OutputStream)jarStream);
        jarStream.closeEntry();
    }

    public static void retry(Runnable r) {
        LocalTestUtil.retry(r, 5, 1.0);
    }

    public static void retry(Runnable r, int retries, double sleepSecs) {
        for (int i = 0; i < retries; ++i) {
            try {
                r.run();
                return;
            }
            catch (Throwable e) {
                try {
                    Thread.sleep((int)(sleepSecs * 1000.0));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i < retries - 1) continue;
                throw new RuntimeException(e);
            }
        }
    }
}

