/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.CommonUtils;
import cloud.localstack.Localstack;
import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv1.TestUtils;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazonaws.HttpMethod;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilter;
import com.amazonaws.services.s3.model.lifecycle.LifecycleFilterPredicate;
import com.amazonaws.services.s3.model.lifecycle.LifecycleTagPredicate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
@LocalstackDockerProperties(services={"s3"}, ignoreDockerRunErrors=true)
public class S3FeaturesTest {
    @Test
    public void testSetBucketLifecycle() throws Exception {
        AmazonS3 client = TestUtils.getClientS3();
        String bucketName = UUID.randomUUID().toString();
        client.createBucket(bucketName);
        BucketLifecycleConfiguration.Rule rule = new BucketLifecycleConfiguration.Rule().withId("expirationRule").withFilter(new LifecycleFilter((LifecycleFilterPredicate)new LifecycleTagPredicate(new Tag("deleted", "true")))).withExpirationInDays(3).withStatus("Enabled");
        BucketLifecycleConfiguration bucketLifecycleConfiguration = new BucketLifecycleConfiguration().withRules(new BucketLifecycleConfiguration.Rule[]{rule});
        client.setBucketLifecycleConfiguration(bucketName, bucketLifecycleConfiguration);
        bucketLifecycleConfiguration = client.getBucketLifecycleConfiguration(bucketName);
        Assert.assertNotNull((Object)bucketLifecycleConfiguration);
        Assert.assertEquals((Object)((BucketLifecycleConfiguration.Rule)bucketLifecycleConfiguration.getRules().get(0)).getId(), (Object)"expirationRule");
        client.deleteBucket(bucketName);
    }

    @Test
    public void testHttpsConnection() {
        if (!Localstack.useSSL()) {
            return;
        }
        CommonUtils.disableSslCertChecking();
        String bucketName = "test-bucket-https";
        AmazonS3 amazonS3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(Localstack.INSTANCE.getEndpointS3(), Localstack.getDefaultRegion()))).withCredentials(TestUtils.getCredentialsProvider())).withChunkedEncodingDisabled(Boolean.valueOf(true))).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        ByteArrayInputStream is = new ByteArrayInputStream("test file content".getBytes());
        amazonS3Client.createBucket(bucketName);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "key1", (InputStream)is, new ObjectMetadata()).withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams("kmsKeyId"));
        PutObjectResult result = amazonS3Client.putObject(putObjectRequest);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getMetadata().getContentType());
        Assert.assertNotNull((Object)result.getMetadata().getETag());
    }

    @Test
    public void testMetadata() {
        AmazonS3 s3 = TestUtils.getClientS3();
        String bucketName = UUID.randomUUID().toString();
        s3.createBucket(bucketName);
        HashMap<String, String> originalMetadata = new HashMap<String, String>();
        originalMetadata.put("key1", "val1");
        originalMetadata.put("key_2", "val2");
        originalMetadata.put("__key3", "val3");
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setUserMetadata(originalMetadata);
        ByteArrayInputStream is = new ByteArrayInputStream("test-string".getBytes(StandardCharsets.UTF_8));
        s3.putObject(new PutObjectRequest(bucketName, "my-key1", (InputStream)is, objectMetadata));
        S3Object getObj = s3.getObject(new GetObjectRequest(bucketName, "my-key1"));
        ObjectMetadata objectMetadataResponse = getObj.getObjectMetadata();
        Map receivedMetadata = objectMetadataResponse.getUserMetadata();
        Assert.assertEquals(originalMetadata, (Object)receivedMetadata);
    }

    @Test
    public void testListNextBatchOfObjects() {
        AmazonS3 s3Client = TestUtils.getClientS3();
        String s3BucketName = UUID.randomUUID().toString();
        s3Client.createBucket(s3BucketName);
        s3Client.putObject(s3BucketName, "key1", "content");
        s3Client.putObject(s3BucketName, "key2", "content");
        s3Client.putObject(s3BucketName, "key3", "content");
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(s3BucketName).withPrefix("").withDelimiter("/").withMaxKeys(Integer.valueOf(1));
        ObjectListing objectListing = s3Client.listObjects(listObjectsRequest);
        LinkedList<Object> someObjList = new LinkedList<Object>();
        someObjList.addAll(this.mapFilesToSomeObject(objectListing));
        while (objectListing.isTruncated()) {
            objectListing = s3Client.listNextBatchOfObjects(objectListing);
            someObjList.addAll(this.mapFilesToSomeObject(objectListing));
        }
        Assert.assertEquals((long)3L, (long)someObjList.size());
    }

    @Test
    public void testUploadEmptyBody() {
        AmazonS3 s3client = TestUtils.getClientS3();
        String bucketName = UUID.randomUUID().toString();
        String keyName = "test-key-empty";
        s3client.createBucket(bucketName);
        ByteArrayInputStream stream = new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8));
        PutObjectRequest request = new PutObjectRequest(bucketName, keyName, (InputStream)stream, new ObjectMetadata());
        PutObjectResult result = s3client.putObject(request);
        Assert.assertEquals((Object)result.getMetadata().getETag(), (Object)"d41d8cd98f00b204e9800998ecf8427e");
    }

    @Test
    public void testPresignedURLUpload() throws Exception {
        AmazonS3 s3client = TestUtils.getClientS3();
        Date expiration = new Date(System.currentTimeMillis() + 300000L);
        String bucketName = UUID.randomUUID().toString();
        String keyName = "presign-test-key";
        s3client.createBucket(bucketName);
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, keyName).withMethod(HttpMethod.PUT).withExpiration(expiration).withKey(keyName);
        URL presignedUrl = s3client.generatePresignedUrl(generatePresignedUrlRequest);
        String content = "test content";
        HttpPut httpPut = new HttpPut(presignedUrl.toString());
        httpPut.setEntity((HttpEntity)new StringEntity(content));
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        httpclient.execute((HttpUriRequest)httpPut);
        httpclient.close();
        GetObjectRequest req = new GetObjectRequest(bucketName, keyName);
        S3Object stream = s3client.getObject(req);
        String result = IOUtils.toString((InputStream)stream.getObjectContent());
        Assert.assertEquals((Object)result, (Object)content);
    }

    private List<Object> mapFilesToSomeObject(ObjectListing objectListing) {
        return objectListing.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList());
    }
}

