/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.docker.Container;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class ContainerTest {
    public static final String EXTERNAL_HOST_NAME = "localhost";
    public static final String MY_PROPERTY = "MY_PROPERTY";
    public static final String MY_VALUE = "MyValue";
    public static final boolean pullNewImage = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createLocalstackContainer() throws Exception {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put(MY_PROPERTY, MY_VALUE);
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)false, (boolean)false, null, null, null, environmentVariables, null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            ArrayList<String> echoDefaultEnv = this.buildEchoStatement("HOSTNAME_EXTERNAL");
            ArrayList<String> echoExternalEnv = this.buildEchoStatement(MY_PROPERTY);
            Assert.assertEquals((Object)EXTERNAL_HOST_NAME, (Object)localStackContainer.executeCommand(echoDefaultEnv));
            Assert.assertEquals((Object)MY_VALUE, (Object)localStackContainer.executeCommand(echoExternalEnv));
            Assert.assertEquals((long)4566L, (long)localStackContainer.getExternalPortFor(4566));
            Assert.assertEquals((long)4571L, (long)localStackContainer.getExternalPortFor(4571));
        }
        finally {
            localStackContainer.stop();
        }
    }

    @Test
    public void createLocalstackContainerWithCustomPorts() throws Exception {
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)false, (boolean)false, null, (String)"45660", (String)"45710", null, null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            Assert.assertEquals((long)45660L, (long)localStackContainer.getExternalPortFor(4566));
            Assert.assertEquals((long)45710L, (long)localStackContainer.getExternalPortFor(4571));
        }
        finally {
            localStackContainer.stop();
        }
    }

    @Test
    public void createLocalstackContainerWithRandomPorts() throws Exception {
        Container localStackContainer = Container.createLocalstackContainer((String)EXTERNAL_HOST_NAME, (boolean)false, (boolean)false, null, (String)":4566", (String)":4571", null, null);
        try {
            localStackContainer.waitForAllPorts(EXTERNAL_HOST_NAME);
            Assert.assertNotEquals((long)4566L, (long)localStackContainer.getExternalPortFor(4566));
            Assert.assertNotEquals((long)4571L, (long)localStackContainer.getExternalPortFor(4571));
        }
        finally {
            localStackContainer.stop();
        }
    }

    private ArrayList<String> buildEchoStatement(String valueToEcho) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("bash");
        args.add("-c");
        args.add(String.format("echo $%s", valueToEcho));
        return args;
    }
}

