/*
 * Decompiled with CFR 0.152.
 */
package cloud.opencode.base.basecode;

import cloud.opencode.base.basecode.enums.ResultMessageEnum;
import cloud.opencode.base.basecode.enums.ResultStatusEnum;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CodeException
extends RuntimeException {
    private static final long serialVersionUID = -9137994707264363383L;
    @Nullable
    private final String message;
    private final HttpStatusCode status;
    @Nullable
    private final Integer code;

    public CodeException() {
        super(ResultMessageEnum.SYSTEM_ERROR.getValue());
        this.message = ResultMessageEnum.SYSTEM_ERROR.getValue();
        this.status = HttpStatus.INTERNAL_SERVER_ERROR;
        this.code = ResultStatusEnum.FAIL.getCode();
    }

    public CodeException(String message) {
        super(message);
        this.message = message;
        this.status = HttpStatus.INTERNAL_SERVER_ERROR;
        this.code = ResultStatusEnum.FAIL.getCode();
    }

    public CodeException(String message, @Nullable HttpStatus status) {
        super(message);
        this.message = message;
        this.status = (HttpStatusCode)Objects.requireNonNullElse(status, HttpStatus.INTERNAL_SERVER_ERROR);
        this.code = ResultStatusEnum.FAIL.getCode();
    }

    public CodeException(String message, @Nullable Throwable cause) {
        super(message, cause);
        this.message = message;
        this.status = HttpStatus.INTERNAL_SERVER_ERROR;
        this.code = ResultStatusEnum.FAIL.getCode();
    }

    public CodeException(String message, @Nullable HttpStatus status, @Nullable Integer code) {
        super(message);
        this.message = message;
        this.status = (HttpStatusCode)Objects.requireNonNullElse(status, HttpStatus.INTERNAL_SERVER_ERROR);
        this.code = Objects.requireNonNullElse(code, ResultStatusEnum.FAIL.getCode());
    }

    public CodeException(String message, @Nullable Integer code, @Nullable Throwable cause) {
        super(message, cause);
        this.message = message;
        this.status = HttpStatus.INTERNAL_SERVER_ERROR;
        this.code = Objects.requireNonNullElse(code, ResultStatusEnum.FAIL.getCode());
    }

    public CodeException(String message, @Nullable HttpStatus status, @Nullable Integer code, @Nullable Throwable cause) {
        super(message, cause);
        this.message = message;
        this.status = (HttpStatusCode)Objects.requireNonNullElse(status, HttpStatus.INTERNAL_SERVER_ERROR);
        this.code = Objects.requireNonNullElse(code, ResultStatusEnum.FAIL.getCode());
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    public HttpStatusCode getStatus() {
        return this.status;
    }

    @Nullable
    public Integer getCode() {
        return this.code;
    }
}

