/*
 * Decompiled with CFR 0.152.
 */
package cloud.topcode.open.code.handler;

import cloud.topcode.open.code.CodeException;
import cloud.topcode.open.code.CodeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class CodeExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CodeExceptionHandler.class);

    @ExceptionHandler(value={IllegalArgumentException.class})
    public CodeResult handleIllegalArgumentException(IllegalArgumentException e) {
        log.error("Error is:{}, Error Info:{}", (Object)"Params error.", (Object)e.getLocalizedMessage());
        return CodeResult.error(500, "Params error.", e.getLocalizedMessage());
    }

    @ExceptionHandler(value={SecurityException.class})
    public CodeResult handleSecurityException(SecurityException e) {
        log.error("Error is:{}, Error Info:{}", (Object)"No access allowed.", (Object)e.getLocalizedMessage());
        return CodeResult.error(500, "No access allowed.", e.getLocalizedMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    public CodeResult handleNullPointerException(NullPointerException e) {
        log.error("Error is:{}, Error Info:{}", (Object)"Null pointer exception.", (Object)e.getLocalizedMessage());
        return CodeResult.error(500, "Null pointer exception.", e.getLocalizedMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public CodeResult handlerNoFoundException(NoHandlerFoundException e) {
        log.error("Error is:{}\uff0cError Info:{}", (Object)"NOT FOUND.", (Object)e.getLocalizedMessage());
        return CodeResult.error(404, "Corresponding resource not found.", e.getLocalizedMessage());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public CodeResult handlerHttpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        log.error("Error is:{}, Error Info:{}", (Object)"Request type is not supported.", (Object)e.getLocalizedMessage());
        return CodeResult.error(500, "Request type is not supported. ", e.getLocalizedMessage());
    }

    @ExceptionHandler(value={CodeException.class})
    public CodeResult handleCodeException(CodeException e) {
        log.error("Error is:{}, Error Info:{}", (Object)e.getLocalizedMessage(), (Object)e.getErrorInfo());
        return CodeResult.error(e.getCode(), e.getLocalizedMessage(), e.getErrorInfo());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public CodeResult handleRuntimeException(RuntimeException e) {
        log.error("Error is:{}, Error Info:{}", (Object)"RuntimeException.", (Object)e.getLocalizedMessage());
        return CodeResult.error(500, "error.", e.getLocalizedMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public CodeResult handleException(Exception e) {
        log.error("Error is:{}, Error Info:{}", (Object)"Error.", (Object)e.getLocalizedMessage());
        return CodeResult.error(500, "error", e.getLocalizedMessage());
    }
}

