/*
 * Decompiled with CFR 0.152.
 */
package cloud.topcode.open.code.handler;

import cloud.topcode.open.code.CodeException;
import cloud.topcode.open.code.CodeResult;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;

@Component
public class CodeExceptionHandlerResolver
implements HandlerExceptionResolver {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ModelAndView resolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) {
        String message = e.getLocalizedMessage();
        String errorInfo = e.getLocalizedMessage();
        Integer code = 500;
        if (e instanceof CodeException) {
            CodeException ce = (CodeException)e;
            code = ce.getCode();
            errorInfo = ce.getErrorInfo();
            message = ce.getMessage();
        }
        if (o instanceof HandlerMethod) {
            if (e instanceof IllegalArgumentException) {
                message = "Params error.";
            } else if (e instanceof SecurityException) {
                message = "No access allowed.";
            } else if (e instanceof NullPointerException) {
                message = "Null pointer exception.";
            }
        } else if (e instanceof NoHandlerFoundException) {
            message = "Corresponding resource not found.";
        } else if (e instanceof HttpMediaTypeNotSupportedException) {
            message = "Request type is not supported.";
        }
        httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
        httpServletResponse.setContentType("application/json");
        try {
            httpServletResponse.getWriter().write(OBJECT_MAPPER.writeValueAsString(CodeResult.error(code, message, errorInfo)));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return new ModelAndView();
    }

    static {
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        OBJECT_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

