/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.api.version.config;

import cn.jdevelops.api.version.util.StrUtil;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class ApiVersionCondition
implements RequestCondition<ApiVersionCondition> {
    private static final Logger LOG = LoggerFactory.getLogger(ApiVersionCondition.class);
    private double apiVersion;

    public ApiVersionCondition(double apiVersion) {
        this.apiVersion = apiVersion;
    }

    public double getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(double apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ApiVersionCondition combine(ApiVersionCondition other) {
        return new ApiVersionCondition(other.getApiVersion());
    }

    public ApiVersionCondition getMatchingCondition(HttpServletRequest httpServletRequest) {
        try {
            double version;
            String reqVersion = httpServletRequest.getParameter("version");
            reqVersion = Optional.ofNullable(reqVersion).orElse(httpServletRequest.getHeader("version"));
            reqVersion = Optional.ofNullable(reqVersion).orElse("1.0");
            if (StrUtil.isNotBlank(reqVersion) && (version = Double.parseDouble(reqVersion)) >= this.apiVersion) {
                return this;
            }
        }
        catch (Exception e) {
            LOG.error("\u5224\u65ad\u7248\u672c\u53f7\u5931\u8d25", (Throwable)e);
            return this;
        }
        return null;
    }

    public int compareTo(ApiVersionCondition apiVersionCondition, HttpServletRequest httpServletRequest) {
        return Double.compare(apiVersionCondition.getApiVersion(), this.apiVersion);
    }
}

