package cn.openjava.basic.format.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 前端树对象
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class Tree implements Serializable {


    private static final long serialVersionUID = 4553728072102774732L;
    /**
     * 唯一标识
     */
    private String id;

    /**
     * 显示值
     */
    private String text;

    /**
     * 是否末级节点
     */
    private boolean leaf;

    /**
     * 子节点
     */
    private List<Tree> children = new ArrayList<>();

    /**
     * 是否展开
     */
    private boolean expanded;


    /**
     * 是否选中
     */
    private boolean checked;

    /**
     * 其他属性
     */
    private Object properties;

}
