/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.basic.format.vo;

import cn.hutool.core.bean.BeanUtil;
import cn.openjava.basic.format.vo.Dict;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grid<T>
implements Serializable {
    private static final long serialVersionUID = 7785748712623137956L;
    private long current;
    private long size;
    private long total;
    private List<T> data;
    private Map<String, List<Dict>> dicts = new HashMap<String, List<Dict>>();
    private long pages;

    public Grid() {
    }

    public Grid(List<T> data) {
        this.data = data;
        this.total = data.size();
        this.pages = 1L;
    }

    public Grid(List<T> data, Map<String, List<Dict>> dicts) {
        this.data = data;
        this.dicts = dicts;
    }

    public Grid(List<T> data, Map<String, List<Dict>> dicts, long current, long size) {
        this.data = data;
        this.dicts = dicts;
        this.current = current;
        this.size = size;
    }

    public Grid(List<T> data, Map<String, List<Dict>> dicts, long current, long size, long total) {
        this.data = data;
        this.dicts = dicts;
        this.current = current;
        this.size = size;
        this.setTotal(total);
    }

    public Grid(List<T> data, Map<String, List<Dict>> dicts, boolean isPaged) {
        this.data = data;
        this.dicts = dicts;
        if (!isPaged) {
            this.total = data.size();
        }
    }

    public Grid<T> setSize(long size) {
        this.size = size;
        this.resetPages();
        return this;
    }

    public Grid<T> setTotal(long total) {
        this.total = total;
        this.resetPages();
        return this;
    }

    private void resetPages() {
        if (this.size > 0L) {
            long t = this.total % this.size == 0L ? this.total / this.size : this.total / this.size + 1L;
            this.setPages(t);
        }
    }

    public Grid setCurrent(long current) {
        this.current = current;
        return this;
    }

    public Grid<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    public Grid<T> setDicts(Map<String, List<Dict>> dicts) {
        this.dicts = dicts;
        return this;
    }

    public Grid<T> setPages(long pages) {
        this.pages = pages;
        return this;
    }

    @Deprecated
    public Grid<T> beanConvert(Class to) {
        ArrayList<Object> data = new ArrayList<Object>();
        for (T t : this.getData()) {
            data.add(BeanUtil.toBean(t, (Class)to));
        }
        this.setData(data);
        return this;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getSize() {
        return this.size;
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getData() {
        return this.data;
    }

    public Map<String, List<Dict>> getDicts() {
        return this.dicts;
    }

    public long getPages() {
        return this.pages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Grid)) {
            return false;
        }
        Grid other = (Grid)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Map<String, List<Dict>> this$dicts = this.getDicts();
        Map<String, List<Dict>> other$dicts = other.getDicts();
        return !(this$dicts == null ? other$dicts != null : !((Object)this$dicts).equals(other$dicts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Grid;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $current = this.getCurrent();
        result = result * 59 + (int)($current >>> 32 ^ $current);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $pages = this.getPages();
        result = result * 59 + (int)($pages >>> 32 ^ $pages);
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Map<String, List<Dict>> $dicts = this.getDicts();
        result = result * 59 + ($dicts == null ? 43 : ((Object)$dicts).hashCode());
        return result;
    }
}

